@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The collection of content validation properties
 * @property contentMatch Content to look for in the return of the WebTest.  Must not be null or empty.
 * @property ignoreCase When set, this value makes the ContentMatch validation case insensitive.
 * @property passIfTextFound When true, validation will pass if there is a match for the ContentMatch string.  If false, validation will fail if there is a match
 */
public data class WebTestPropertiesResponseContentValidation(
    public val contentMatch: String? = null,
    public val ignoreCase: Boolean? = null,
    public val passIfTextFound: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.WebTestPropertiesResponseContentValidation):
            WebTestPropertiesResponseContentValidation = WebTestPropertiesResponseContentValidation(
            contentMatch = javaType.contentMatch().map({ args0 -> args0 }).orElse(null),
            ignoreCase = javaType.ignoreCase().map({ args0 -> args0 }).orElse(null),
            passIfTextFound = javaType.passIfTextFound().map({ args0 -> args0 }).orElse(null),
        )
    }
}
