@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Webhook notification of an autoscale event.
 * @property properties a property bag of settings. This value can be empty.
 * @property serviceUri the service address to receive the notification.
 */
public data class WebhookNotificationResponse(
    public val properties: Map<String, String>? = null,
    public val serviceUri: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.WebhookNotificationResponse):
            WebhookNotificationResponse = WebhookNotificationResponse(
            properties = javaType.properties().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            serviceUri = javaType.serviceUri().map({ args0 -> args0 }).orElse(null),
        )
    }
}
