@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Definition of which Windows Event Log events will be collected and how they will be collected.
 * Only collected from Windows machines.
 * @property name A friendly name for the data source.
 * This name should be unique across all data sources (regardless of type) within the data collection rule.
 * @property streams List of streams that this data source will be sent to.
 * A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
 * @property xPathQueries A list of Windows Event Log queries in XPATH format.
 */
public data class WindowsEventLogDataSourceResponse(
    public val name: String? = null,
    public val streams: List<String>? = null,
    public val xPathQueries: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.WindowsEventLogDataSourceResponse):
            WindowsEventLogDataSourceResponse = WindowsEventLogDataSourceResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            streams = javaType.streams().map({ args0 -> args0 }),
            xPathQueries = javaType.xPathQueries().map({ args0 -> args0 }),
        )
    }
}
