@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.integrationspaces.kotlin.inputs

import com.pulumi.azurenative.integrationspaces.inputs.GetSpacePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property spaceName The name of the space
 */
public data class GetSpacePlainArgs(
    public val resourceGroupName: String,
    public val spaceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.integrationspaces.inputs.GetSpacePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.integrationspaces.inputs.GetSpacePlainArgs =
        com.pulumi.azurenative.integrationspaces.inputs.GetSpacePlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .spaceName(spaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSpacePlainArgs].
 */
@PulumiTagMarker
public class GetSpacePlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var spaceName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mlbjjxhvcexakbmq")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the space
     */
    @JvmName("brruluoqosfxirwu")
    public suspend fun spaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.spaceName = mapped
    }

    internal fun build(): GetSpacePlainArgs = GetSpacePlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        spaceName = spaceName ?: throw PulumiNullFieldException("spaceName"),
    )
}
