@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.integrationspaces.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The properties of business process development artifact.
 * @property businessProcessMapping The business process mapping.
 * @property businessProcessStages The business process stages.
 * @property description The description of the business process.
 * @property identifier The business process identifier.
 * @property trackingProfiles The tracking profile for the business process.
 */
public data class BusinessProcessDevelopmentArtifactPropertiesResponse(
    public val businessProcessMapping: Map<String, BusinessProcessMappingItemResponse>? = null,
    public val businessProcessStages: Map<String, BusinessProcessStageResponse>? = null,
    public val description: String? = null,
    public val identifier: BusinessProcessIdentifierResponse? = null,
    public val trackingProfiles: Map<String, TrackingProfileDefinitionResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.integrationspaces.outputs.BusinessProcessDevelopmentArtifactPropertiesResponse):
            BusinessProcessDevelopmentArtifactPropertiesResponse =
            BusinessProcessDevelopmentArtifactPropertiesResponse(
                businessProcessMapping = javaType.businessProcessMapping().map({ args0 ->
                    args0.key.to(
                        args0.value.let({ args0 ->
                            com.pulumi.azurenative.integrationspaces.kotlin.outputs.BusinessProcessMappingItemResponse.Companion.toKotlin(args0)
                        }),
                    )
                }).toMap(),
                businessProcessStages = javaType.businessProcessStages().map({ args0 ->
                    args0.key.to(
                        args0.value.let({ args0 ->
                            com.pulumi.azurenative.integrationspaces.kotlin.outputs.BusinessProcessStageResponse.Companion.toKotlin(args0)
                        }),
                    )
                }).toMap(),
                description = javaType.description().map({ args0 -> args0 }).orElse(null),
                identifier = javaType.identifier().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.integrationspaces.kotlin.outputs.BusinessProcessIdentifierResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                trackingProfiles = javaType.trackingProfiles().map({ args0 ->
                    args0.key.to(
                        args0.value.let({ args0 ->
                            com.pulumi.azurenative.integrationspaces.kotlin.outputs.TrackingProfileDefinitionResponse.Companion.toKotlin(args0)
                        }),
                    )
                }).toMap(),
            )
    }
}
