@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.intune.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * iOS Policy entity for Intune MAM.
 * @property accessRecheckOfflineTimeout
 * @property accessRecheckOnlineTimeout
 * @property appSharingFromLevel
 * @property appSharingToLevel
 * @property authentication
 * @property clipboardSharingLevel
 * @property dataBackup
 * @property description
 * @property deviceCompliance
 * @property fileEncryptionLevel
 * @property fileSharingSaveAs
 * @property friendlyName
 * @property groupStatus
 * @property id Resource Id
 * @property lastModifiedTime
 * @property location Resource Location
 * @property managedBrowser
 * @property name Resource name
 * @property numOfApps
 * @property offlineWipeTimeout
 * @property pin
 * @property pinNumRetry
 * @property tags Resource Tags
 * @property touchId
 * @property type Resource type
 */
public data class GetIoMAMPolicyByNameResult(
    public val accessRecheckOfflineTimeout: String? = null,
    public val accessRecheckOnlineTimeout: String? = null,
    public val appSharingFromLevel: String? = null,
    public val appSharingToLevel: String? = null,
    public val authentication: String? = null,
    public val clipboardSharingLevel: String? = null,
    public val dataBackup: String? = null,
    public val description: String? = null,
    public val deviceCompliance: String? = null,
    public val fileEncryptionLevel: String? = null,
    public val fileSharingSaveAs: String? = null,
    public val friendlyName: String,
    public val groupStatus: String,
    public val id: String,
    public val lastModifiedTime: String,
    public val location: String? = null,
    public val managedBrowser: String? = null,
    public val name: String,
    public val numOfApps: Int,
    public val offlineWipeTimeout: String? = null,
    public val pin: String? = null,
    public val pinNumRetry: Int? = null,
    public val tags: Map<String, String>? = null,
    public val touchId: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.intune.outputs.GetIoMAMPolicyByNameResult):
            GetIoMAMPolicyByNameResult = GetIoMAMPolicyByNameResult(
            accessRecheckOfflineTimeout = javaType.accessRecheckOfflineTimeout().map({ args0 ->
                args0
            }).orElse(null),
            accessRecheckOnlineTimeout = javaType.accessRecheckOnlineTimeout().map({ args0 ->
                args0
            }).orElse(null),
            appSharingFromLevel = javaType.appSharingFromLevel().map({ args0 -> args0 }).orElse(null),
            appSharingToLevel = javaType.appSharingToLevel().map({ args0 -> args0 }).orElse(null),
            authentication = javaType.authentication().map({ args0 -> args0 }).orElse(null),
            clipboardSharingLevel = javaType.clipboardSharingLevel().map({ args0 -> args0 }).orElse(null),
            dataBackup = javaType.dataBackup().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            deviceCompliance = javaType.deviceCompliance().map({ args0 -> args0 }).orElse(null),
            fileEncryptionLevel = javaType.fileEncryptionLevel().map({ args0 -> args0 }).orElse(null),
            fileSharingSaveAs = javaType.fileSharingSaveAs().map({ args0 -> args0 }).orElse(null),
            friendlyName = javaType.friendlyName(),
            groupStatus = javaType.groupStatus(),
            id = javaType.id(),
            lastModifiedTime = javaType.lastModifiedTime(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            managedBrowser = javaType.managedBrowser().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            numOfApps = javaType.numOfApps(),
            offlineWipeTimeout = javaType.offlineWipeTimeout().map({ args0 -> args0 }).orElse(null),
            pin = javaType.pin().map({ args0 -> args0 }).orElse(null),
            pinNumRetry = javaType.pinNumRetry().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            touchId = javaType.touchId().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
