@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotfirmwaredefense.kotlin

import com.pulumi.azurenative.iotfirmwaredefense.WorkspaceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Firmware analysis workspace.
 * Azure REST API version: 2023-02-08-preview.
 * ## Example Usage
 * ### Workspaces_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspace = new AzureNative.IoTFirmwareDefense.Workspace("workspace", new()
 *     {
 *         Location = "jjwbseilitjgdrhbvvkwviqj",
 *         ResourceGroupName = "rgworkspaces",
 *         Tags =
 *         {
 *             { "key450", "rzqqumbpfsbibnpirsm" },
 *         },
 *         WorkspaceName = "E___-3",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/iotfirmwaredefense/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iotfirmwaredefense.NewWorkspace(ctx, "workspace", &iotfirmwaredefense.WorkspaceArgs{
 * 			Location:          pulumi.String("jjwbseilitjgdrhbvvkwviqj"),
 * 			ResourceGroupName: pulumi.String("rgworkspaces"),
 * 			Tags: pulumi.StringMap{
 * 				"key450": pulumi.String("rzqqumbpfsbibnpirsm"),
 * 			},
 * 			WorkspaceName: pulumi.String("E___-3"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.iotfirmwaredefense.Workspace;
 * import com.pulumi.azurenative.iotfirmwaredefense.WorkspaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspace = new Workspace("workspace", WorkspaceArgs.builder()
 *             .location("jjwbseilitjgdrhbvvkwviqj")
 *             .resourceGroupName("rgworkspaces")
 *             .tags(Map.of("key450", "rzqqumbpfsbibnpirsm"))
 *             .workspaceName("E___-3")
 *             .build());
 *     }
 * }
 * ```
 * ### Workspaces_Create_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspace = new AzureNative.IoTFirmwareDefense.Workspace("workspace", new()
 *     {
 *         Location = "jjwbseilitjgdrhbvvkwviqj",
 *         ResourceGroupName = "rgworkspaces",
 *         WorkspaceName = "E___-3",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/iotfirmwaredefense/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iotfirmwaredefense.NewWorkspace(ctx, "workspace", &iotfirmwaredefense.WorkspaceArgs{
 * 			Location:          pulumi.String("jjwbseilitjgdrhbvvkwviqj"),
 * 			ResourceGroupName: pulumi.String("rgworkspaces"),
 * 			WorkspaceName:     pulumi.String("E___-3"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.iotfirmwaredefense.Workspace;
 * import com.pulumi.azurenative.iotfirmwaredefense.WorkspaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspace = new Workspace("workspace", WorkspaceArgs.builder()
 *             .location("jjwbseilitjgdrhbvvkwviqj")
 *             .resourceGroupName("rgworkspaces")
 *             .workspaceName("E___-3")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:iotfirmwaredefense:Workspace tbrqhnzpsatbrnhtj /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}
 * ```
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 * @property workspaceName The name of the firmware analysis workspace.
 */
public data class WorkspaceArgs(
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.iotfirmwaredefense.WorkspaceArgs> {
    override fun toJava(): com.pulumi.azurenative.iotfirmwaredefense.WorkspaceArgs =
        com.pulumi.azurenative.iotfirmwaredefense.WorkspaceArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkspaceArgs].
 */
@PulumiTagMarker
public class WorkspaceArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ihiqwyxmrytajfxj")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("haufuhdxflhfrkty")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("hqamypgsryfnhqjc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the firmware analysis workspace.
     */
    @JvmName("hmlmygrcsfwdrtqu")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("xqolyofmjisxooms")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ypmaldsbdatpabxr")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("amvyigakrsxtknfs")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("rlkfenolpuuyhcau")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of the firmware analysis workspace.
     */
    @JvmName("khacqsvnqbwjhgtj")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): WorkspaceArgs = WorkspaceArgs(
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
        workspaceName = workspaceName,
    )
}
