@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsdataprocessor.kotlin

import com.pulumi.azurenative.iotoperationsdataprocessor.InstanceArgs.builder
import com.pulumi.azurenative.iotoperationsdataprocessor.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.iotoperationsdataprocessor.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A Instance resource is a logical container for a set of child resources.
 * Azure REST API version: 2023-10-04-preview.
 * ## Example Usage
 * ### Instances create or update - generated by [MaximumSet] rule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var instance = new AzureNative.IoTOperationsDataProcessor.Instance("instance", new()
 *     {
 *         Description = "ytazzjdwgnnwsmexqasgpyabrtkgtf",
 *         ExtendedLocation = new AzureNative.IoTOperationsDataProcessor.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/e0aaa3df-e9a4-456a-9824-3c3b5c438110/resourceGroups/IoTOperationsDataProcessor-rg/providers/Microsoft.ExtendedLocation/customLocations/dev-space",
 *             Type = "CustomLocation",
 *         },
 *         InstanceName = "15wp-47-e60s18w",
 *         Location = "westus",
 *         ResourceGroupName = "rgopenapi",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/iotoperationsdataprocessor/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iotoperationsdataprocessor.NewInstance(ctx, "instance", &iotoperationsdataprocessor.InstanceArgs{
 * 			Description: pulumi.String("ytazzjdwgnnwsmexqasgpyabrtkgtf"),
 * 			ExtendedLocation: &iotoperationsdataprocessor.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/e0aaa3df-e9a4-456a-9824-3c3b5c438110/resourceGroups/IoTOperationsDataProcessor-rg/providers/Microsoft.ExtendedLocation/customLocations/dev-space"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			InstanceName:      pulumi.String("15wp-47-e60s18w"),
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("rgopenapi"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.iotoperationsdataprocessor.Instance;
 * import com.pulumi.azurenative.iotoperationsdataprocessor.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var instance = new Instance("instance", InstanceArgs.builder()
 *             .description("ytazzjdwgnnwsmexqasgpyabrtkgtf")
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "/subscriptions/e0aaa3df-e9a4-456a-9824-3c3b5c438110/resourceGroups/IoTOperationsDataProcessor-rg/providers/Microsoft.ExtendedLocation/customLocations/dev-space"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .instanceName("15wp-47-e60s18w")
 *             .location("westus")
 *             .resourceGroupName("rgopenapi")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:iotoperationsdataprocessor:Instance IoTOperationsDataProcessor-instance-name /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTOperationsDataProcessor/instances/{instanceName}
 * ```
 * @property description Detailed description of the Instance.
 * @property extendedLocation Edge location of the resource.
 * @property instanceName Name of instance.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class InstanceArgs(
    public val description: Output<String>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val instanceName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsdataprocessor.InstanceArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsdataprocessor.InstanceArgs =
        com.pulumi.azurenative.iotoperationsdataprocessor.InstanceArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .instanceName(instanceName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [InstanceArgs].
 */
@PulumiTagMarker
public class InstanceArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var instanceName: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Detailed description of the Instance.
     */
    @JvmName("jkckmgfvxjsplowy")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Edge location of the resource.
     */
    @JvmName("hpjbmsvnpbsnayuh")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value Name of instance.
     */
    @JvmName("tcxmxljlscfihsgy")
    public suspend fun instanceName(`value`: Output<String>) {
        this.instanceName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("hnnfbadopxpkuqci")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ngjyrlbiykimopwq")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("xmiaqbkwnuawryyo")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Detailed description of the Instance.
     */
    @JvmName("gyskinjotphhkkbr")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Edge location of the resource.
     */
    @JvmName("jtobtssugjvovogd")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument Edge location of the resource.
     */
    @JvmName("kenumrydbowrqcox")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value Name of instance.
     */
    @JvmName("eirsmxiijlgddrpb")
    public suspend fun instanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceName = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("xaynduxmtfgsxdcg")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("nvryhtwbytgshpai")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("rekowarljglauays")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("prmtivuvoumuguun")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): InstanceArgs = InstanceArgs(
        description = description,
        extendedLocation = extendedLocation,
        instanceName = instanceName,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
