@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsdataprocessor.kotlin

import com.pulumi.azurenative.iotoperationsdataprocessor.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.iotoperationsdataprocessor.kotlin.outputs.PipelineInputResponse
import com.pulumi.azurenative.iotoperationsdataprocessor.kotlin.outputs.PipelineStageResponse
import com.pulumi.azurenative.iotoperationsdataprocessor.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.iotoperationsdataprocessor.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.iotoperationsdataprocessor.kotlin.outputs.PipelineInputResponse.Companion.toKotlin as pipelineInputResponseToKotlin
import com.pulumi.azurenative.iotoperationsdataprocessor.kotlin.outputs.PipelineStageResponse.Companion.toKotlin as pipelineStageResponseToKotlin
import com.pulumi.azurenative.iotoperationsdataprocessor.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Pipeline].
 */
@PulumiTagMarker
public class PipelineResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PipelineArgs = PipelineArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PipelineArgsBuilder.() -> Unit) {
        val builder = PipelineArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Pipeline {
        val builtJavaResource =
            com.pulumi.azurenative.iotoperationsdataprocessor.Pipeline(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Pipeline(builtJavaResource)
    }
}

/**
 * A Pipeline resource belonging to an Instance resource.
 * Azure REST API version: 2023-10-04-preview.
 * ## Example Usage
 * ### Pipelines create or update - generated by [MaximumSet] rule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var pipeline = new AzureNative.IoTOperationsDataProcessor.Pipeline("pipeline", new()
 *     {
 *         Description = "vayzklhg",
 *         Enabled = true,
 *         ExtendedLocation = new AzureNative.IoTOperationsDataProcessor.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/e0aaa3df-e9a4-456a-9824-3c3b5c438110/resourceGroups/IoTOperationsDataProcessor-rg/providers/Microsoft.ExtendedLocation/customLocations/dev-space",
 *             Type = "CustomLocation",
 *         },
 *         Input = new AzureNative.IoTOperationsDataProcessor.Inputs.PipelineInputArgs
 *         {
 *             Next = new[]
 *             {
 *                 "umnuwjk",
 *             },
 *             Type = "xrnubjkvzajxjzb",
 *         },
 *         InstanceName = "056k5pl8t7761-2--ej25u2l28ttb-22mh79-75-2ch-t8",
 *         Location = "westus",
 *         PipelineName = "j8-8--3",
 *         ResourceGroupName = "rgopenapi",
 *         Stages =
 *         {
 *             { "stageId", new AzureNative.IoTOperationsDataProcessor.Inputs.PipelineStageArgs
 *             {
 *                 Next = new[]
 *                 {
 *                     "gxqgqh",
 *                 },
 *                 Type = "cxqgblrzqniowabexbztempdpkuib",
 *             } },
 *         },
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/iotoperationsdataprocessor/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iotoperationsdataprocessor.NewPipeline(ctx, "pipeline", &iotoperationsdataprocessor.PipelineArgs{
 * 			Description: pulumi.String("vayzklhg"),
 * 			Enabled:     pulumi.Bool(true),
 * 			ExtendedLocation: &iotoperationsdataprocessor.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/e0aaa3df-e9a4-456a-9824-3c3b5c438110/resourceGroups/IoTOperationsDataProcessor-rg/providers/Microsoft.ExtendedLocation/customLocations/dev-space"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			Input: &iotoperationsdataprocessor.PipelineInputTypeArgs{
 * 				Next: pulumi.StringArray{
 * 					pulumi.String("umnuwjk"),
 * 				},
 * 				Type: pulumi.String("xrnubjkvzajxjzb"),
 * 			},
 * 			InstanceName:      pulumi.String("056k5pl8t7761-2--ej25u2l28ttb-22mh79-75-2ch-t8"),
 * 			Location:          pulumi.String("westus"),
 * 			PipelineName:      pulumi.String("j8-8--3"),
 * 			ResourceGroupName: pulumi.String("rgopenapi"),
 * 			Stages: iotoperationsdataprocessor.PipelineStageMap{
 * 				"stageId": &iotoperationsdataprocessor.PipelineStageArgs{
 * 					Next: pulumi.StringArray{
 * 						pulumi.String("gxqgqh"),
 * 					},
 * 					Type: pulumi.String("cxqgblrzqniowabexbztempdpkuib"),
 * 				},
 * 			},
 * 			Tags: nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.iotoperationsdataprocessor.Pipeline;
 * import com.pulumi.azurenative.iotoperationsdataprocessor.PipelineArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pipeline = new Pipeline("pipeline", PipelineArgs.builder()
 *             .description("vayzklhg")
 *             .enabled(true)
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "/subscriptions/e0aaa3df-e9a4-456a-9824-3c3b5c438110/resourceGroups/IoTOperationsDataProcessor-rg/providers/Microsoft.ExtendedLocation/customLocations/dev-space"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .input(Map.ofEntries(
 *                 Map.entry("next", "umnuwjk"),
 *                 Map.entry("type", "xrnubjkvzajxjzb")
 *             ))
 *             .instanceName("056k5pl8t7761-2--ej25u2l28ttb-22mh79-75-2ch-t8")
 *             .location("westus")
 *             .pipelineName("j8-8--3")
 *             .resourceGroupName("rgopenapi")
 *             .stages(Map.of("stageId", Map.ofEntries(
 *                 Map.entry("next", "gxqgqh"),
 *                 Map.entry("type", "cxqgblrzqniowabexbztempdpkuib")
 *             )))
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:iotoperationsdataprocessor:Pipeline IoTOperationsDataProcessor-pipeline-name /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTOperationsDataProcessor/instances/{instanceName}/pipelines/{pipelineName}
 * ```
 */
public class Pipeline internal constructor(
    override val javaResource: com.pulumi.azurenative.iotoperationsdataprocessor.Pipeline,
) : KotlinCustomResource(javaResource, PipelineMapper) {
    /**
     * Detailed description of the Pipeline.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Flag indicating whether the pipeline should be running or not.
     */
    public val enabled: Output<Boolean>
        get() = javaResource.enabled().applyValue({ args0 -> args0 })

    /**
     * Edge location of the resource.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.let({ args0 ->
                extendedLocationResponseToKotlin(args0)
            })
        })

    /**
     * Information about where to pull input data from.
     */
    public val input: Output<PipelineInputResponse>
        get() = javaResource.input().applyValue({ args0 ->
            args0.let({ args0 ->
                pipelineInputResponseToKotlin(args0)
            })
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Map of stage ids to stage configurations for all pipeline processing and output stages.
     */
    public val stages: Output<Map<String, PipelineStageResponse>>
        get() = javaResource.stages().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value.let({ args0 -> pipelineStageResponseToKotlin(args0) }))
            }).toMap()
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PipelineMapper : ResourceMapper<Pipeline> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.iotoperationsdataprocessor.Pipeline::class == javaResource::class

    override fun map(javaResource: Resource): Pipeline = Pipeline(
        javaResource as
            com.pulumi.azurenative.iotoperationsdataprocessor.Pipeline,
    )
}

/**
 * @see [Pipeline].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Pipeline].
 */
public suspend fun pipeline(name: String, block: suspend PipelineResourceBuilder.() -> Unit):
    Pipeline {
    val builder = PipelineResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Pipeline].
 * @param name The _unique_ name of the resulting resource.
 */
public fun pipeline(name: String): Pipeline {
    val builder = PipelineResourceBuilder()
    builder.name(name)
    return builder.build()
}
