@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsdataprocessor.kotlin.inputs

import com.pulumi.azurenative.iotoperationsdataprocessor.inputs.GetDatasetPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property datasetName Name of dataset.
 * @property instanceName Name of instance.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetDatasetPlainArgs(
    public val datasetName: String,
    public val instanceName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsdataprocessor.inputs.GetDatasetPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.iotoperationsdataprocessor.inputs.GetDatasetPlainArgs =
        com.pulumi.azurenative.iotoperationsdataprocessor.inputs.GetDatasetPlainArgs.builder()
            .datasetName(datasetName.let({ args0 -> args0 }))
            .instanceName(instanceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDatasetPlainArgs].
 */
@PulumiTagMarker
public class GetDatasetPlainArgsBuilder internal constructor() {
    private var datasetName: String? = null

    private var instanceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of dataset.
     */
    @JvmName("mhecnmviufaumlba")
    public suspend fun datasetName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.datasetName = mapped
    }

    /**
     * @param value Name of instance.
     */
    @JvmName("pmnjvlritsbytqtb")
    public suspend fun instanceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vadiyirqdutbfafx")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDatasetPlainArgs = GetDatasetPlainArgs(
        datasetName = datasetName ?: throw PulumiNullFieldException("datasetName"),
        instanceName = instanceName ?: throw PulumiNullFieldException("instanceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
