@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsdataprocessor.kotlin.inputs

import com.pulumi.azurenative.iotoperationsdataprocessor.inputs.GetInstancePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property instanceName Name of instance.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetInstancePlainArgs(
    public val instanceName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsdataprocessor.inputs.GetInstancePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.iotoperationsdataprocessor.inputs.GetInstancePlainArgs =
        com.pulumi.azurenative.iotoperationsdataprocessor.inputs.GetInstancePlainArgs.builder()
            .instanceName(instanceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetInstancePlainArgs].
 */
@PulumiTagMarker
public class GetInstancePlainArgsBuilder internal constructor() {
    private var instanceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of instance.
     */
    @JvmName("oqmemhqvyrkjuhsw")
    public suspend fun instanceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lwpayyviqxykyddr")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetInstancePlainArgs = GetInstancePlainArgs(
        instanceName = instanceName ?: throw PulumiNullFieldException("instanceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
