@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin

import com.pulumi.azurenative.iotoperationsmq.BrokerArgs.builder
import com.pulumi.azurenative.iotoperationsmq.kotlin.enums.BrokerMemoryProfile
import com.pulumi.azurenative.iotoperationsmq.kotlin.enums.RunMode
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.BrokerDiagnosticsArgs
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.BrokerDiagnosticsArgsBuilder
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.CardinalityArgs
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.CardinalityArgsBuilder
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.CertManagerCertOptionsArgs
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.CertManagerCertOptionsArgsBuilder
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.ContainerImageArgs
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.ContainerImageArgsBuilder
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.DiskBackedMessageBufferSettingsArgs
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.DiskBackedMessageBufferSettingsArgsBuilder
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.ExtendedLocationPropertyArgs
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.ExtendedLocationPropertyArgsBuilder
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.NodeTolerationsArgs
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.NodeTolerationsArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * MQ broker resource
 * Azure REST API version: 2023-10-04-preview.
 * ## Example Usage
 * ### Broker_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var broker = new AzureNative.IoTOperationsMQ.Broker("broker", new()
 *     {
 *         AuthImage = new AzureNative.IoTOperationsMQ.Inputs.ContainerImageArgs
 *         {
 *             PullPolicy = "imfuzvqxgbdwliqnn",
 *             PullSecrets = "klnqimxqsrdwhcqldjvdtsrs",
 *             Repository = "m",
 *             Tag = "jygfdiamhhm",
 *         },
 *         BrokerImage = new AzureNative.IoTOperationsMQ.Inputs.ContainerImageArgs
 *         {
 *             PullPolicy = "imfuzvqxgbdwliqnn",
 *             PullSecrets = "klnqimxqsrdwhcqldjvdtsrs",
 *             Repository = "m",
 *             Tag = "jygfdiamhhm",
 *         },
 *         BrokerName = "29tAwt4A2-aH6nP",
 *         BrokerNodeTolerations = new AzureNative.IoTOperationsMQ.Inputs.NodeTolerationsArgs
 *         {
 *             Effect = "eeswvciblqmmaeesjoflyvxqbz",
 *             Key = "wbrstdwxgm",
 *             Operator = "lbegegneekwnyodtzraarivtwhmzep",
 *             Value = "sfafsjdcezdmkwibxeluukxgl",
 *         },
 *         Cardinality = new AzureNative.IoTOperationsMQ.Inputs.CardinalityArgs
 *         {
 *             BackendChain = new AzureNative.IoTOperationsMQ.Inputs.BackendChainArgs
 *             {
 *                 Partitions = 34721,
 *                 RedundancyFactor = 468,
 *                 TemporaryDiskTransferEnabled = true,
 *                 TemporaryDiskTransferHighWatermarkPercent = 79,
 *                 TemporaryDiskTransferLowWatermarkPercent = 94,
 *                 TemporaryMaxBackendMemUsagePercent = 54,
 *                 TemporaryResourceLimits = new AzureNative.IoTOperationsMQ.Inputs.TemporaryResourceLimitsConfigArgs
 *                 {
 *                     MaxInflightMessages = 33208,
 *                     MaxInflightPatches = 3410,
 *                     MaxInflightPatchesPerClient = 58933,
 *                     MaxMessageExpirySecs = 2036532516,
 *                     MaxQueuedMessages = 8083241696687839232,
 *                     MaxQueuedQos0Messages = 6545343433569253376,
 *                     MaxSessionExpirySecs = 2526293894,
 *                 },
 *                 Workers = 15754,
 *             },
 *             Frontend = new AzureNative.IoTOperationsMQ.Inputs.FrontendArgs
 *             {
 *                 Replicas = 38165,
 *                 TemporaryResourceLimits = new AzureNative.IoTOperationsMQ.Inputs.TemporaryResourceLimitsConfigArgs
 *                 {
 *                     MaxInflightMessages = 33208,
 *                     MaxInflightPatches = 3410,
 *                     MaxInflightPatchesPerClient = 58933,
 *                     MaxMessageExpirySecs = 2036532516,
 *                     MaxQueuedMessages = 8083241696687839232,
 *                     MaxQueuedQos0Messages = 6545343433569253376,
 *                     MaxSessionExpirySecs = 2526293894,
 *                 },
 *                 Workers = 38,
 *             },
 *         },
 *         Diagnostics = new AzureNative.IoTOperationsMQ.Inputs.BrokerDiagnosticsArgs
 *         {
 *             DiagnosticServiceEndpoint = "cdvelitwasofaaqhdb",
 *             EnableMetrics = true,
 *             EnableSelfCheck = true,
 *             EnableSelfTracing = true,
 *             EnableTracing = true,
 *             LogFormat = "tcivnlakxcajynypbz",
 *             LogLevel = "zdjh",
 *             MaxCellMapLifetime = 997099872515057664,
 *             MetricUpdateFrequencySeconds = 6156703238506293248,
 *             ProbeImage = "uzizubdxsgcpjwly",
 *             SelfCheckFrequencySeconds = 579622483050303872,
 *             SelfCheckTimeoutSeconds = 7847246333600883712,
 *             SelfTraceFrequencySeconds = 6527612490765174784,
 *             SpanChannelCapacity = 5533451650716961792,
 *         },
 *         DiskBackedMessageBufferSettings = new AzureNative.IoTOperationsMQ.Inputs.DiskBackedMessageBufferSettingsArgs
 *         {
 *             EphemeralVolumeClaimSpec = new AzureNative.IoTOperationsMQ.Inputs.VolumeClaimSpecArgs
 *             {
 *                 AccessModes = new[]
 *                 {
 *                     "cly",
 *                 },
 *                 DataSource = new AzureNative.IoTOperationsMQ.Inputs.VolumeClaimDataSourceArgs
 *                 {
 *                     ApiGroup = "v",
 *                     Kind = "pvzbnjebkoslzzucpaem",
 *                     Name = "bgzdfwfpdrubbbnfwzyr",
 *                 },
 *                 DataSourceRef = new AzureNative.IoTOperationsMQ.Inputs.VolumeClaimDataSourceRefArgs
 *                 {
 *                     ApiGroup = "e",
 *                     Kind = "hjbktqbtg",
 *                     Name = "losjjcujomepwhztzptrobavolc",
 *                 },
 *                 Resources = new AzureNative.IoTOperationsMQ.Inputs.VolumeClaimResourceRequirementsArgs
 *                 {
 *                     Limits = null,
 *                     Requests = null,
 *                 },
 *                 Selector = new AzureNative.IoTOperationsMQ.Inputs.VolumeClaimSpecSelectorArgs
 *                 {
 *                     MatchExpressions = new[]
 *                     {
 *                         new AzureNative.IoTOperationsMQ.Inputs.VolumeClaimSpecSelectorMatchExpressionsArgs
 *                         {
 *                             Key = "d",
 *                             Operator = "fcfvoarytcdbtccjervsmdis",
 *                             Values = new[]
 *                             {
 *                                 "y",
 *                             },
 *                         },
 *                     },
 *                     MatchLabels = null,
 *                 },
 *                 StorageClassName = "etajfhrtgatxi",
 *                 VolumeMode = "mipdeutsgidkzpxelbrqggjheplvmx",
 *                 VolumeName = "dacuvlvuullautxjxwdctvzlmd",
 *             },
 *             MaxSize = "gnwxgqjypylz",
 *             PersistentVolumeClaimSpec = new AzureNative.IoTOperationsMQ.Inputs.VolumeClaimSpecArgs
 *             {
 *                 AccessModes = new[]
 *                 {
 *                     "cly",
 *                 },
 *                 DataSource = new AzureNative.IoTOperationsMQ.Inputs.VolumeClaimDataSourceArgs
 *                 {
 *                     ApiGroup = "v",
 *                     Kind = "pvzbnjebkoslzzucpaem",
 *                     Name = "bgzdfwfpdrubbbnfwzyr",
 *                 },
 *                 DataSourceRef = new AzureNative.IoTOperationsMQ.Inputs.VolumeClaimDataSourceRefArgs
 *                 {
 *                     ApiGroup = "e",
 *                     Kind = "hjbktqbtg",
 *                     Name = "losjjcujomepwhztzptrobavolc",
 *                 },
 *                 Resources = new AzureNative.IoTOperationsMQ.Inputs.VolumeClaimResourceRequirementsArgs
 *                 {
 *                     Limits = null,
 *                     Requests = null,
 *                 },
 *                 Selector = new AzureNative.IoTOperationsMQ.Inputs.VolumeClaimSpecSelectorArgs
 *                 {
 *                     MatchExpressions = new[]
 *                     {
 *                         new AzureNative.IoTOperationsMQ.Inputs.VolumeClaimSpecSelectorMatchExpressionsArgs
 *                         {
 *                             Key = "d",
 *                             Operator = "fcfvoarytcdbtccjervsmdis",
 *                             Values = new[]
 *                             {
 *                                 "y",
 *                             },
 *                         },
 *                     },
 *                     MatchLabels = null,
 *                 },
 *                 StorageClassName = "etajfhrtgatxi",
 *                 VolumeMode = "mipdeutsgidkzpxelbrqggjheplvmx",
 *                 VolumeName = "dacuvlvuullautxjxwdctvzlmd",
 *             },
 *         },
 *         EncryptInternalTraffic = true,
 *         ExtendedLocation = new AzureNative.IoTOperationsMQ.Inputs.ExtendedLocationPropertyArgs
 *         {
 *             Name = "an",
 *             Type = "CustomLocation",
 *         },
 *         HealthManagerImage = new AzureNative.IoTOperationsMQ.Inputs.ContainerImageArgs
 *         {
 *             PullPolicy = "imfuzvqxgbdwliqnn",
 *             PullSecrets = "klnqimxqsrdwhcqldjvdtsrs",
 *             Repository = "m",
 *             Tag = "jygfdiamhhm",
 *         },
 *         HealthManagerNodeTolerations = new AzureNative.IoTOperationsMQ.Inputs.NodeTolerationsArgs
 *         {
 *             Effect = "eeswvciblqmmaeesjoflyvxqbz",
 *             Key = "wbrstdwxgm",
 *             Operator = "lbegegneekwnyodtzraarivtwhmzep",
 *             Value = "sfafsjdcezdmkwibxeluukxgl",
 *         },
 *         InternalCerts = new AzureNative.IoTOperationsMQ.Inputs.CertManagerCertOptionsArgs
 *         {
 *             Duration = "xjjmzq",
 *             PrivateKey = new AzureNative.IoTOperationsMQ.Inputs.CertManagerPrivateKeyArgs
 *             {
 *                 Algorithm = "wwewfsddymjefuhxzqybwvay",
 *                 RotationPolicy = "jxmpyvfneckopjiakjtous",
 *                 Size = 63427,
 *             },
 *             RenewBefore = "zkajhllevrxkfmfyzasmbllvd",
 *         },
 *         Location = "ltzfwqzs",
 *         MemoryProfile = "tiny",
 *         Mode = "auto",
 *         MqName = "u229L1RZ5",
 *         ResourceGroupName = "rgiotoperationsmq",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/iotoperationsmq/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := iotoperationsmq.NewBroker(ctx, "broker", &iotoperationsmq.BrokerArgs{
 * AuthImage: &iotoperationsmq.ContainerImageArgs{
 * PullPolicy: pulumi.String("imfuzvqxgbdwliqnn"),
 * PullSecrets: pulumi.String("klnqimxqsrdwhcqldjvdtsrs"),
 * Repository: pulumi.String("m"),
 * Tag: pulumi.String("jygfdiamhhm"),
 * },
 * BrokerImage: &iotoperationsmq.ContainerImageArgs{
 * PullPolicy: pulumi.String("imfuzvqxgbdwliqnn"),
 * PullSecrets: pulumi.String("klnqimxqsrdwhcqldjvdtsrs"),
 * Repository: pulumi.String("m"),
 * Tag: pulumi.String("jygfdiamhhm"),
 * },
 * BrokerName: pulumi.String("29tAwt4A2-aH6nP"),
 * BrokerNodeTolerations: &iotoperationsmq.NodeTolerationsArgs{
 * Effect: pulumi.String("eeswvciblqmmaeesjoflyvxqbz"),
 * Key: pulumi.String("wbrstdwxgm"),
 * Operator: pulumi.String("lbegegneekwnyodtzraarivtwhmzep"),
 * Value: pulumi.String("sfafsjdcezdmkwibxeluukxgl"),
 * },
 * Cardinality: iotoperationsmq.CardinalityResponse{
 * BackendChain: interface{}{
 * Partitions: pulumi.Int(34721),
 * RedundancyFactor: pulumi.Int(468),
 * TemporaryDiskTransferEnabled: pulumi.Bool(true),
 * TemporaryDiskTransferHighWatermarkPercent: pulumi.Int(79),
 * TemporaryDiskTransferLowWatermarkPercent: pulumi.Int(94),
 * TemporaryMaxBackendMemUsagePercent: pulumi.Int(54),
 * TemporaryResourceLimits: &iotoperationsmq.TemporaryResourceLimitsConfigArgs{
 * MaxInflightMessages: pulumi.Int(33208),
 * MaxInflightPatches: pulumi.Int(3410),
 * MaxInflightPatchesPerClient: pulumi.Int(58933),
 * MaxMessageExpirySecs: pulumi.Float64(2036532516),
 * MaxQueuedMessages: pulumi.Float64(8083241696687839232),
 * MaxQueuedQos0Messages: pulumi.Float64(6545343433569253376),
 * MaxSessionExpirySecs: pulumi.Float64(2526293894),
 * },
 * Workers: pulumi.Int(15754),
 * },
 * Frontend: interface{}{
 * Replicas: pulumi.Int(38165),
 * TemporaryResourceLimits: &iotoperationsmq.TemporaryResourceLimitsConfigArgs{
 * MaxInflightMessages: pulumi.Int(33208),
 * MaxInflightPatches: pulumi.Int(3410),
 * MaxInflightPatchesPerClient: pulumi.Int(58933),
 * MaxMessageExpirySecs: pulumi.Float64(2036532516),
 * MaxQueuedMessages: pulumi.Float64(8083241696687839232),
 * MaxQueuedQos0Messages: pulumi.Float64(6545343433569253376),
 * MaxSessionExpirySecs: pulumi.Float64(2526293894),
 * },
 * Workers: pulumi.Int(38),
 * },
 * },
 * Diagnostics: &iotoperationsmq.BrokerDiagnosticsArgs{
 * DiagnosticServiceEndpoint: pulumi.String("cdvelitwasofaaqhdb"),
 * EnableMetrics: pulumi.Bool(true),
 * EnableSelfCheck: pulumi.Bool(true),
 * EnableSelfTracing: pulumi.Bool(true),
 * EnableTracing: pulumi.Bool(true),
 * LogFormat: pulumi.String("tcivnlakxcajynypbz"),
 * LogLevel: pulumi.String("zdjh"),
 * MaxCellMapLifetime: pulumi.Float64(997099872515057664),
 * MetricUpdateFrequencySeconds: pulumi.Float64(6156703238506293248),
 * ProbeImage: pulumi.String("uzizubdxsgcpjwly"),
 * SelfCheckFrequencySeconds: pulumi.Float64(579622483050303872),
 * SelfCheckTimeoutSeconds: pulumi.Float64(7847246333600883712),
 * SelfTraceFrequencySeconds: pulumi.Float64(6527612490765174784),
 * SpanChannelCapacity: pulumi.Float64(5533451650716961792),
 * },
 * DiskBackedMessageBufferSettings: iotoperationsmq.DiskBackedMessageBufferSettingsResponse{
 * EphemeralVolumeClaimSpec: interface{}{
 * AccessModes: pulumi.StringArray{
 * pulumi.String("cly"),
 * },
 * DataSource: &iotoperationsmq.VolumeClaimDataSourceArgs{
 * ApiGroup: pulumi.String("v"),
 * Kind: pulumi.String("pvzbnjebkoslzzucpaem"),
 * Name: pulumi.String("bgzdfwfpdrubbbnfwzyr"),
 * },
 * DataSourceRef: &iotoperationsmq.VolumeClaimDataSourceRefArgs{
 * ApiGroup: pulumi.String("e"),
 * Kind: pulumi.String("hjbktqbtg"),
 * Name: pulumi.String("losjjcujomepwhztzptrobavolc"),
 * },
 * Resources: &iotoperationsmq.VolumeClaimResourceRequirementsArgs{
 * Limits: nil,
 * Requests: nil,
 * },
 * Selector: interface{}{
 * MatchExpressions: iotoperationsmq.VolumeClaimSpecSelectorMatchExpressionsArray{
 * &iotoperationsmq.VolumeClaimSpecSelectorMatchExpressionsArgs{
 * Key: pulumi.String("d"),
 * Operator: pulumi.String("fcfvoarytcdbtccjervsmdis"),
 * Values: pulumi.StringArray{
 * pulumi.String("y"),
 * },
 * },
 * },
 * MatchLabels: nil,
 * },
 * StorageClassName: pulumi.String("etajfhrtgatxi"),
 * VolumeMode: pulumi.String("mipdeutsgidkzpxelbrqggjheplvmx"),
 * VolumeName: pulumi.String("dacuvlvuullautxjxwdctvzlmd"),
 * },
 * MaxSize: pulumi.String("gnwxgqjypylz"),
 * PersistentVolumeClaimSpec: interface{}{
 * AccessModes: pulumi.StringArray{
 * pulumi.String("cly"),
 * },
 * DataSource: &iotoperationsmq.VolumeClaimDataSourceArgs{
 * ApiGroup: pulumi.String("v"),
 * Kind: pulumi.String("pvzbnjebkoslzzucpaem"),
 * Name: pulumi.String("bgzdfwfpdrubbbnfwzyr"),
 * },
 * DataSourceRef: &iotoperationsmq.VolumeClaimDataSourceRefArgs{
 * ApiGroup: pulumi.String("e"),
 * Kind: pulumi.String("hjbktqbtg"),
 * Name: pulumi.String("losjjcujomepwhztzptrobavolc"),
 * },
 * Resources: &iotoperationsmq.VolumeClaimResourceRequirementsArgs{
 * Limits: nil,
 * Requests: nil,
 * },
 * Selector: interface{}{
 * MatchExpressions: iotoperationsmq.VolumeClaimSpecSelectorMatchExpressionsArray{
 * &iotoperationsmq.VolumeClaimSpecSelectorMatchExpressionsArgs{
 * Key: pulumi.String("d"),
 * Operator: pulumi.String("fcfvoarytcdbtccjervsmdis"),
 * Values: pulumi.StringArray{
 * pulumi.String("y"),
 * },
 * },
 * },
 * MatchLabels: nil,
 * },
 * StorageClassName: pulumi.String("etajfhrtgatxi"),
 * VolumeMode: pulumi.String("mipdeutsgidkzpxelbrqggjheplvmx"),
 * VolumeName: pulumi.String("dacuvlvuullautxjxwdctvzlmd"),
 * },
 * },
 * EncryptInternalTraffic: pulumi.Bool(true),
 * ExtendedLocation: &iotoperationsmq.ExtendedLocationPropertyArgs{
 * Name: pulumi.String("an"),
 * Type: pulumi.String("CustomLocation"),
 * },
 * HealthManagerImage: &iotoperationsmq.ContainerImageArgs{
 * PullPolicy: pulumi.String("imfuzvqxgbdwliqnn"),
 * PullSecrets: pulumi.String("klnqimxqsrdwhcqldjvdtsrs"),
 * Repository: pulumi.String("m"),
 * Tag: pulumi.String("jygfdiamhhm"),
 * },
 * HealthManagerNodeTolerations: &iotoperationsmq.NodeTolerationsArgs{
 * Effect: pulumi.String("eeswvciblqmmaeesjoflyvxqbz"),
 * Key: pulumi.String("wbrstdwxgm"),
 * Operator: pulumi.String("lbegegneekwnyodtzraarivtwhmzep"),
 * Value: pulumi.String("sfafsjdcezdmkwibxeluukxgl"),
 * },
 * InternalCerts: iotoperationsmq.CertManagerCertOptionsResponse{
 * Duration: pulumi.String("xjjmzq"),
 * PrivateKey: &iotoperationsmq.CertManagerPrivateKeyArgs{
 * Algorithm: pulumi.String("wwewfsddymjefuhxzqybwvay"),
 * RotationPolicy: pulumi.String("jxmpyvfneckopjiakjtous"),
 * Size: pulumi.Int(63427),
 * },
 * RenewBefore: pulumi.String("zkajhllevrxkfmfyzasmbllvd"),
 * },
 * Location: pulumi.String("ltzfwqzs"),
 * MemoryProfile: pulumi.String("tiny"),
 * Mode: pulumi.String("auto"),
 * MqName: pulumi.String("u229L1RZ5"),
 * ResourceGroupName: pulumi.String("rgiotoperationsmq"),
 * Tags: nil,
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.iotoperationsmq.Broker;
 * import com.pulumi.azurenative.iotoperationsmq.BrokerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var broker = new Broker("broker", BrokerArgs.builder()
 *             .authImage(Map.ofEntries(
 *                 Map.entry("pullPolicy", "imfuzvqxgbdwliqnn"),
 *                 Map.entry("pullSecrets", "klnqimxqsrdwhcqldjvdtsrs"),
 *                 Map.entry("repository", "m"),
 *                 Map.entry("tag", "jygfdiamhhm")
 *             ))
 *             .brokerImage(Map.ofEntries(
 *                 Map.entry("pullPolicy", "imfuzvqxgbdwliqnn"),
 *                 Map.entry("pullSecrets", "klnqimxqsrdwhcqldjvdtsrs"),
 *                 Map.entry("repository", "m"),
 *                 Map.entry("tag", "jygfdiamhhm")
 *             ))
 *             .brokerName("29tAwt4A2-aH6nP")
 *             .brokerNodeTolerations(Map.ofEntries(
 *                 Map.entry("effect", "eeswvciblqmmaeesjoflyvxqbz"),
 *                 Map.entry("key", "wbrstdwxgm"),
 *                 Map.entry("operator", "lbegegneekwnyodtzraarivtwhmzep"),
 *                 Map.entry("value", "sfafsjdcezdmkwibxeluukxgl")
 *             ))
 *             .cardinality(Map.ofEntries(
 *                 Map.entry("backendChain", Map.ofEntries(
 *                     Map.entry("partitions", 34721),
 *                     Map.entry("redundancyFactor", 468),
 *                     Map.entry("temporaryDiskTransferEnabled", true),
 *                     Map.entry("temporaryDiskTransferHighWatermarkPercent", 79),
 *                     Map.entry("temporaryDiskTransferLowWatermarkPercent", 94),
 *                     Map.entry("temporaryMaxBackendMemUsagePercent", 54),
 *                     Map.entry("temporaryResourceLimits", Map.ofEntries(
 *                         Map.entry("maxInflightMessages", 33208),
 *                         Map.entry("maxInflightPatches", 3410),
 *                         Map.entry("maxInflightPatchesPerClient", 58933),
 *                         Map.entry("maxMessageExpirySecs", 2036532516),
 *                         Map.entry("maxQueuedMessages", 8083241696687839232),
 *                         Map.entry("maxQueuedQos0Messages", 6545343433569253376),
 *                         Map.entry("maxSessionExpirySecs", 2526293894)
 *                     )),
 *                     Map.entry("workers", 15754)
 *                 )),
 *                 Map.entry("frontend", Map.ofEntries(
 *                     Map.entry("replicas", 38165),
 *                     Map.entry("temporaryResourceLimits", Map.ofEntries(
 *                         Map.entry("maxInflightMessages", 33208),
 *                         Map.entry("maxInflightPatches", 3410),
 *                         Map.entry("maxInflightPatchesPerClient", 58933),
 *                         Map.entry("maxMessageExpirySecs", 2036532516),
 *                         Map.entry("maxQueuedMessages", 8083241696687839232),
 *                         Map.entry("maxQueuedQos0Messages", 6545343433569253376),
 *                         Map.entry("maxSessionExpirySecs", 2526293894)
 *                     )),
 *                     Map.entry("workers", 38)
 *                 ))
 *             ))
 *             .diagnostics(Map.ofEntries(
 *                 Map.entry("diagnosticServiceEndpoint", "cdvelitwasofaaqhdb"),
 *                 Map.entry("enableMetrics", true),
 *                 Map.entry("enableSelfCheck", true),
 *                 Map.entry("enableSelfTracing", true),
 *                 Map.entry("enableTracing", true),
 *                 Map.entry("logFormat", "tcivnlakxcajynypbz"),
 *                 Map.entry("logLevel", "zdjh"),
 *                 Map.entry("maxCellMapLifetime", 997099872515057664),
 *                 Map.entry("metricUpdateFrequencySeconds", 6156703238506293248),
 *                 Map.entry("probeImage", "uzizubdxsgcpjwly"),
 *                 Map.entry("selfCheckFrequencySeconds", 579622483050303872),
 *                 Map.entry("selfCheckTimeoutSeconds", 7847246333600883712),
 *                 Map.entry("selfTraceFrequencySeconds", 6527612490765174784),
 *                 Map.entry("spanChannelCapacity", 5533451650716961792)
 *             ))
 *             .diskBackedMessageBufferSettings(Map.ofEntries(
 *                 Map.entry("ephemeralVolumeClaimSpec", Map.ofEntries(
 *                     Map.entry("accessModes", "cly"),
 *                     Map.entry("dataSource", Map.ofEntries(
 *                         Map.entry("apiGroup", "v"),
 *                         Map.entry("kind", "pvzbnjebkoslzzucpaem"),
 *                         Map.entry("name", "bgzdfwfpdrubbbnfwzyr")
 *                     )),
 *                     Map.entry("dataSourceRef", Map.ofEntries(
 *                         Map.entry("apiGroup", "e"),
 *                         Map.entry("kind", "hjbktqbtg"),
 *                         Map.entry("name", "losjjcujomepwhztzptrobavolc")
 *                     )),
 *                     Map.entry("resources", Map.ofEntries(
 *                         Map.entry("limits", ),
 *                         Map.entry("requests", )
 *                     )),
 *                     Map.entry("selector", Map.ofEntries(
 *                         Map.entry("matchExpressions", Map.ofEntries(
 *                             Map.entry("key", "d"),
 *                             Map.entry("operator", "fcfvoarytcdbtccjervsmdis"),
 *                             Map.entry("values", "y")
 *                         )),
 *                         Map.entry("matchLabels", )
 *                     )),
 *                     Map.entry("storageClassName", "etajfhrtgatxi"),
 *                     Map.entry("volumeMode", "mipdeutsgidkzpxelbrqggjheplvmx"),
 *                     Map.entry("volumeName", "dacuvlvuullautxjxwdctvzlmd")
 *                 )),
 *                 Map.entry("maxSize", "gnwxgqjypylz"),
 *                 Map.entry("persistentVolumeClaimSpec", Map.ofEntries(
 *                     Map.entry("accessModes", "cly"),
 *                     Map.entry("dataSource", Map.ofEntries(
 *                         Map.entry("apiGroup", "v"),
 *                         Map.entry("kind", "pvzbnjebkoslzzucpaem"),
 *                         Map.entry("name", "bgzdfwfpdrubbbnfwzyr")
 *                     )),
 *                     Map.entry("dataSourceRef", Map.ofEntries(
 *                         Map.entry("apiGroup", "e"),
 *                         Map.entry("kind", "hjbktqbtg"),
 *                         Map.entry("name", "losjjcujomepwhztzptrobavolc")
 *                     )),
 *                     Map.entry("resources", Map.ofEntries(
 *                         Map.entry("limits", ),
 *                         Map.entry("requests", )
 *                     )),
 *                     Map.entry("selector", Map.ofEntries(
 *                         Map.entry("matchExpressions", Map.ofEntries(
 *                             Map.entry("key", "d"),
 *                             Map.entry("operator", "fcfvoarytcdbtccjervsmdis"),
 *                             Map.entry("values", "y")
 *                         )),
 *                         Map.entry("matchLabels", )
 *                     )),
 *                     Map.entry("storageClassName", "etajfhrtgatxi"),
 *                     Map.entry("volumeMode", "mipdeutsgidkzpxelbrqggjheplvmx"),
 *                     Map.entry("volumeName", "dacuvlvuullautxjxwdctvzlmd")
 *                 ))
 *             ))
 *             .encryptInternalTraffic(true)
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "an"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .healthManagerImage(Map.ofEntries(
 *                 Map.entry("pullPolicy", "imfuzvqxgbdwliqnn"),
 *                 Map.entry("pullSecrets", "klnqimxqsrdwhcqldjvdtsrs"),
 *                 Map.entry("repository", "m"),
 *                 Map.entry("tag", "jygfdiamhhm")
 *             ))
 *             .healthManagerNodeTolerations(Map.ofEntries(
 *                 Map.entry("effect", "eeswvciblqmmaeesjoflyvxqbz"),
 *                 Map.entry("key", "wbrstdwxgm"),
 *                 Map.entry("operator", "lbegegneekwnyodtzraarivtwhmzep"),
 *                 Map.entry("value", "sfafsjdcezdmkwibxeluukxgl")
 *             ))
 *             .internalCerts(Map.ofEntries(
 *                 Map.entry("duration", "xjjmzq"),
 *                 Map.entry("privateKey", Map.ofEntries(
 *                     Map.entry("algorithm", "wwewfsddymjefuhxzqybwvay"),
 *                     Map.entry("rotationPolicy", "jxmpyvfneckopjiakjtous"),
 *                     Map.entry("size", 63427)
 *                 )),
 *                 Map.entry("renewBefore", "zkajhllevrxkfmfyzasmbllvd")
 *             ))
 *             .location("ltzfwqzs")
 *             .memoryProfile("tiny")
 *             .mode("auto")
 *             .mqName("u229L1RZ5")
 *             .resourceGroupName("rgiotoperationsmq")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:iotoperationsmq:Broker blyxqmvmwlzftkvi /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTOperationsMQ/mq/{mqName}/broker/{brokerName}
 * ```
 * @property authImage The details of Authentication Docker Image.
 * @property brokerImage The details of Broker Docker Image.
 * @property brokerName Name of MQ broker resource
 * @property brokerNodeTolerations The details of Node Tolerations for Broker Pods.
 * @property cardinality The cardinality details of the broker.
 * @property diagnostics The diagnostic details of the broker deployment.
 * @property diskBackedMessageBufferSettings The settings of the disk-backed message buffer.
 * @property encryptInternalTraffic The setting to enable or disable encryption of internal Traffic.
 * @property extendedLocation Extended Location
 * @property healthManagerImage The details of Health Manager Docker Image.
 * @property healthManagerNodeTolerations The details of Node Tolerations for Health Manager Pods.
 * @property internalCerts Details of the internal CA cert that will be used to secure communication between pods.
 * @property location The geo-location where the resource lives
 * @property memoryProfile Memory profile of broker.
 * @property mode The Running Mode of the Broker Deployment.
 * @property mqName Name of MQ resource
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class BrokerArgs(
    public val authImage: Output<ContainerImageArgs>? = null,
    public val brokerImage: Output<ContainerImageArgs>? = null,
    public val brokerName: Output<String>? = null,
    public val brokerNodeTolerations: Output<NodeTolerationsArgs>? = null,
    public val cardinality: Output<CardinalityArgs>? = null,
    public val diagnostics: Output<BrokerDiagnosticsArgs>? = null,
    public val diskBackedMessageBufferSettings: Output<DiskBackedMessageBufferSettingsArgs>? = null,
    public val encryptInternalTraffic: Output<Boolean>? = null,
    public val extendedLocation: Output<ExtendedLocationPropertyArgs>? = null,
    public val healthManagerImage: Output<ContainerImageArgs>? = null,
    public val healthManagerNodeTolerations: Output<NodeTolerationsArgs>? = null,
    public val internalCerts: Output<CertManagerCertOptionsArgs>? = null,
    public val location: Output<String>? = null,
    public val memoryProfile: Output<Either<String, BrokerMemoryProfile>>? = null,
    public val mode: Output<Either<String, RunMode>>? = null,
    public val mqName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.BrokerArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.BrokerArgs =
        com.pulumi.azurenative.iotoperationsmq.BrokerArgs.builder()
            .authImage(authImage?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .brokerImage(brokerImage?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .brokerName(brokerName?.applyValue({ args0 -> args0 }))
            .brokerNodeTolerations(
                brokerNodeTolerations?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .cardinality(cardinality?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .diagnostics(diagnostics?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .diskBackedMessageBufferSettings(
                diskBackedMessageBufferSettings?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .encryptInternalTraffic(encryptInternalTraffic?.applyValue({ args0 -> args0 }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .healthManagerImage(
                healthManagerImage?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .healthManagerNodeTolerations(
                healthManagerNodeTolerations?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .internalCerts(internalCerts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .memoryProfile(
                memoryProfile?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .mode(
                mode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .mqName(mqName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [BrokerArgs].
 */
@PulumiTagMarker
public class BrokerArgsBuilder internal constructor() {
    private var authImage: Output<ContainerImageArgs>? = null

    private var brokerImage: Output<ContainerImageArgs>? = null

    private var brokerName: Output<String>? = null

    private var brokerNodeTolerations: Output<NodeTolerationsArgs>? = null

    private var cardinality: Output<CardinalityArgs>? = null

    private var diagnostics: Output<BrokerDiagnosticsArgs>? = null

    private var diskBackedMessageBufferSettings: Output<DiskBackedMessageBufferSettingsArgs>? = null

    private var encryptInternalTraffic: Output<Boolean>? = null

    private var extendedLocation: Output<ExtendedLocationPropertyArgs>? = null

    private var healthManagerImage: Output<ContainerImageArgs>? = null

    private var healthManagerNodeTolerations: Output<NodeTolerationsArgs>? = null

    private var internalCerts: Output<CertManagerCertOptionsArgs>? = null

    private var location: Output<String>? = null

    private var memoryProfile: Output<Either<String, BrokerMemoryProfile>>? = null

    private var mode: Output<Either<String, RunMode>>? = null

    private var mqName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The details of Authentication Docker Image.
     */
    @JvmName("rcuwtiubyuggcjrm")
    public suspend fun authImage(`value`: Output<ContainerImageArgs>) {
        this.authImage = value
    }

    /**
     * @param value The details of Broker Docker Image.
     */
    @JvmName("ggxtxwpthecglxys")
    public suspend fun brokerImage(`value`: Output<ContainerImageArgs>) {
        this.brokerImage = value
    }

    /**
     * @param value Name of MQ broker resource
     */
    @JvmName("evohljgayjojvdgl")
    public suspend fun brokerName(`value`: Output<String>) {
        this.brokerName = value
    }

    /**
     * @param value The details of Node Tolerations for Broker Pods.
     */
    @JvmName("hgtawknjqhjwqxge")
    public suspend fun brokerNodeTolerations(`value`: Output<NodeTolerationsArgs>) {
        this.brokerNodeTolerations = value
    }

    /**
     * @param value The cardinality details of the broker.
     */
    @JvmName("pfcfhhhoegegqaws")
    public suspend fun cardinality(`value`: Output<CardinalityArgs>) {
        this.cardinality = value
    }

    /**
     * @param value The diagnostic details of the broker deployment.
     */
    @JvmName("nyuwnkopdrfmqrll")
    public suspend fun diagnostics(`value`: Output<BrokerDiagnosticsArgs>) {
        this.diagnostics = value
    }

    /**
     * @param value The settings of the disk-backed message buffer.
     */
    @JvmName("xbxtpdmcwlkrjtbm")
    public suspend
    fun diskBackedMessageBufferSettings(`value`: Output<DiskBackedMessageBufferSettingsArgs>) {
        this.diskBackedMessageBufferSettings = value
    }

    /**
     * @param value The setting to enable or disable encryption of internal Traffic.
     */
    @JvmName("dguyqnxidbjqgxeh")
    public suspend fun encryptInternalTraffic(`value`: Output<Boolean>) {
        this.encryptInternalTraffic = value
    }

    /**
     * @param value Extended Location
     */
    @JvmName("nwpftijmgaxbwxko")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationPropertyArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The details of Health Manager Docker Image.
     */
    @JvmName("amkfewtcuajkrpky")
    public suspend fun healthManagerImage(`value`: Output<ContainerImageArgs>) {
        this.healthManagerImage = value
    }

    /**
     * @param value The details of Node Tolerations for Health Manager Pods.
     */
    @JvmName("qbygxpcepasydoao")
    public suspend fun healthManagerNodeTolerations(`value`: Output<NodeTolerationsArgs>) {
        this.healthManagerNodeTolerations = value
    }

    /**
     * @param value Details of the internal CA cert that will be used to secure communication between pods.
     */
    @JvmName("ktnupbhwmduixxwr")
    public suspend fun internalCerts(`value`: Output<CertManagerCertOptionsArgs>) {
        this.internalCerts = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("hgswdebrobofhesd")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Memory profile of broker.
     */
    @JvmName("iqxxdrgnotextsnd")
    public suspend fun memoryProfile(`value`: Output<Either<String, BrokerMemoryProfile>>) {
        this.memoryProfile = value
    }

    /**
     * @param value The Running Mode of the Broker Deployment.
     */
    @JvmName("apybgagoapfmvnkd")
    public suspend fun mode(`value`: Output<Either<String, RunMode>>) {
        this.mode = value
    }

    /**
     * @param value Name of MQ resource
     */
    @JvmName("utbudyseaicydgfd")
    public suspend fun mqName(`value`: Output<String>) {
        this.mqName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wtlwwieuxqvdixdv")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ukremgivwhjqtwbv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The details of Authentication Docker Image.
     */
    @JvmName("eayyxvymlyexsnqs")
    public suspend fun authImage(`value`: ContainerImageArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authImage = mapped
    }

    /**
     * @param argument The details of Authentication Docker Image.
     */
    @JvmName("tvkgjgdntvpctxqu")
    public suspend fun authImage(argument: suspend ContainerImageArgsBuilder.() -> Unit) {
        val toBeMapped = ContainerImageArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.authImage = mapped
    }

    /**
     * @param value The details of Broker Docker Image.
     */
    @JvmName("fxhuoqtttyffeymg")
    public suspend fun brokerImage(`value`: ContainerImageArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.brokerImage = mapped
    }

    /**
     * @param argument The details of Broker Docker Image.
     */
    @JvmName("xpdtyyxssvplyxrv")
    public suspend fun brokerImage(argument: suspend ContainerImageArgsBuilder.() -> Unit) {
        val toBeMapped = ContainerImageArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.brokerImage = mapped
    }

    /**
     * @param value Name of MQ broker resource
     */
    @JvmName("yrcludljrxoqcxvf")
    public suspend fun brokerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.brokerName = mapped
    }

    /**
     * @param value The details of Node Tolerations for Broker Pods.
     */
    @JvmName("cfgliogtwcqqndak")
    public suspend fun brokerNodeTolerations(`value`: NodeTolerationsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.brokerNodeTolerations = mapped
    }

    /**
     * @param argument The details of Node Tolerations for Broker Pods.
     */
    @JvmName("gjynsuqiootowimy")
    public suspend
    fun brokerNodeTolerations(argument: suspend NodeTolerationsArgsBuilder.() -> Unit) {
        val toBeMapped = NodeTolerationsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.brokerNodeTolerations = mapped
    }

    /**
     * @param value The cardinality details of the broker.
     */
    @JvmName("nabulicyublddgkn")
    public suspend fun cardinality(`value`: CardinalityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cardinality = mapped
    }

    /**
     * @param argument The cardinality details of the broker.
     */
    @JvmName("dlykfycflpkdhyak")
    public suspend fun cardinality(argument: suspend CardinalityArgsBuilder.() -> Unit) {
        val toBeMapped = CardinalityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.cardinality = mapped
    }

    /**
     * @param value The diagnostic details of the broker deployment.
     */
    @JvmName("agrsuhgrxwomupoe")
    public suspend fun diagnostics(`value`: BrokerDiagnosticsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diagnostics = mapped
    }

    /**
     * @param argument The diagnostic details of the broker deployment.
     */
    @JvmName("qixffdveeqjscqgc")
    public suspend fun diagnostics(argument: suspend BrokerDiagnosticsArgsBuilder.() -> Unit) {
        val toBeMapped = BrokerDiagnosticsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.diagnostics = mapped
    }

    /**
     * @param value The settings of the disk-backed message buffer.
     */
    @JvmName("khharycfhruckfgb")
    public suspend
    fun diskBackedMessageBufferSettings(`value`: DiskBackedMessageBufferSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskBackedMessageBufferSettings = mapped
    }

    /**
     * @param argument The settings of the disk-backed message buffer.
     */
    @JvmName("byrhusqsfxduyhin")
    public suspend
    fun diskBackedMessageBufferSettings(argument: suspend DiskBackedMessageBufferSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = DiskBackedMessageBufferSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.diskBackedMessageBufferSettings = mapped
    }

    /**
     * @param value The setting to enable or disable encryption of internal Traffic.
     */
    @JvmName("jmbjcbhplgucfqec")
    public suspend fun encryptInternalTraffic(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptInternalTraffic = mapped
    }

    /**
     * @param value Extended Location
     */
    @JvmName("qbgiybkcijvdfpwm")
    public suspend fun extendedLocation(`value`: ExtendedLocationPropertyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument Extended Location
     */
    @JvmName("urtgbuusrmuvaaep")
    public suspend
    fun extendedLocation(argument: suspend ExtendedLocationPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationPropertyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The details of Health Manager Docker Image.
     */
    @JvmName("vnarcvmiupjvakot")
    public suspend fun healthManagerImage(`value`: ContainerImageArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthManagerImage = mapped
    }

    /**
     * @param argument The details of Health Manager Docker Image.
     */
    @JvmName("kxjedautohfnquik")
    public suspend fun healthManagerImage(argument: suspend ContainerImageArgsBuilder.() -> Unit) {
        val toBeMapped = ContainerImageArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.healthManagerImage = mapped
    }

    /**
     * @param value The details of Node Tolerations for Health Manager Pods.
     */
    @JvmName("olmroksoqosciwve")
    public suspend fun healthManagerNodeTolerations(`value`: NodeTolerationsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthManagerNodeTolerations = mapped
    }

    /**
     * @param argument The details of Node Tolerations for Health Manager Pods.
     */
    @JvmName("mtejktsthnqgqelj")
    public suspend
    fun healthManagerNodeTolerations(argument: suspend NodeTolerationsArgsBuilder.() -> Unit) {
        val toBeMapped = NodeTolerationsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.healthManagerNodeTolerations = mapped
    }

    /**
     * @param value Details of the internal CA cert that will be used to secure communication between pods.
     */
    @JvmName("udsjqkbiqgmfkoye")
    public suspend fun internalCerts(`value`: CertManagerCertOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internalCerts = mapped
    }

    /**
     * @param argument Details of the internal CA cert that will be used to secure communication between pods.
     */
    @JvmName("sxjaryhxgmaywbss")
    public suspend fun internalCerts(argument: suspend CertManagerCertOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = CertManagerCertOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.internalCerts = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ijluuvwbtgiholfo")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Memory profile of broker.
     */
    @JvmName("jlsnuobormlmslxu")
    public suspend fun memoryProfile(`value`: Either<String, BrokerMemoryProfile>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memoryProfile = mapped
    }

    /**
     * @param value Memory profile of broker.
     */
    @JvmName("pkvejklwiuabkjks")
    public fun memoryProfile(`value`: String) {
        val toBeMapped = Either.ofLeft<String, BrokerMemoryProfile>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.memoryProfile = mapped
    }

    /**
     * @param value Memory profile of broker.
     */
    @JvmName("ofrssvaohnbmghgf")
    public fun memoryProfile(`value`: BrokerMemoryProfile) {
        val toBeMapped = Either.ofRight<String, BrokerMemoryProfile>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.memoryProfile = mapped
    }

    /**
     * @param value The Running Mode of the Broker Deployment.
     */
    @JvmName("pvtcmhwjsuxnusew")
    public suspend fun mode(`value`: Either<String, RunMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value The Running Mode of the Broker Deployment.
     */
    @JvmName("hqjibrcvcljnfaje")
    public fun mode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RunMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value The Running Mode of the Broker Deployment.
     */
    @JvmName("qnrlbydyuamvyqir")
    public fun mode(`value`: RunMode) {
        val toBeMapped = Either.ofRight<String, RunMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value Name of MQ resource
     */
    @JvmName("wuoswrqlmdatiatd")
    public suspend fun mqName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mqName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("canfxwxhfbelfmpx")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("fyojeuxksqpgkykd")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("hvqrhcdvlgqejyra")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): BrokerArgs = BrokerArgs(
        authImage = authImage,
        brokerImage = brokerImage,
        brokerName = brokerName,
        brokerNodeTolerations = brokerNodeTolerations,
        cardinality = cardinality,
        diagnostics = diagnostics,
        diskBackedMessageBufferSettings = diskBackedMessageBufferSettings,
        encryptInternalTraffic = encryptInternalTraffic,
        extendedLocation = extendedLocation,
        healthManagerImage = healthManagerImage,
        healthManagerNodeTolerations = healthManagerNodeTolerations,
        internalCerts = internalCerts,
        location = location,
        memoryProfile = memoryProfile,
        mode = mode,
        mqName = mqName,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
