@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin

import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.ExtendedLocationPropertyResponse
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.TlsCertMethodResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.ExtendedLocationPropertyResponse.Companion.toKotlin as extendedLocationPropertyResponseToKotlin
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.TlsCertMethodResponse.Companion.toKotlin as tlsCertMethodResponseToKotlin

/**
 * Builder for [BrokerListener].
 */
@PulumiTagMarker
public class BrokerListenerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BrokerListenerArgs = BrokerListenerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BrokerListenerArgsBuilder.() -> Unit) {
        val builder = BrokerListenerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): BrokerListener {
        val builtJavaResource =
            com.pulumi.azurenative.iotoperationsmq.BrokerListener(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return BrokerListener(builtJavaResource)
    }
}

/**
 * MQ broker/listener resource
 * Azure REST API version: 2023-10-04-preview.
 * ## Example Usage
 * ### BrokerListener_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var brokerListener = new AzureNative.IoTOperationsMQ.BrokerListener("brokerListener", new()
 *     {
 *         AuthenticationEnabled = true,
 *         AuthorizationEnabled = true,
 *         BrokerName = "HGF6WIy6oHv756MjW0JRLILF",
 *         BrokerRef = "ikuszpfycikq",
 *         ExtendedLocation = new AzureNative.IoTOperationsMQ.Inputs.ExtendedLocationPropertyArgs
 *         {
 *             Name = "an",
 *             Type = "CustomLocation",
 *         },
 *         ListenerName = "XGEP",
 *         Location = "dppbdcpstouifyko",
 *         MqName = "Z1-2BCdNY4JO--84",
 *         NodePort = 34375,
 *         Port = 19791,
 *         ResourceGroupName = "rgiotoperationsmq",
 *         ServiceName = "euxa",
 *         ServiceType = "clusterIp",
 *         Tags = null,
 *         Tls = new AzureNative.IoTOperationsMQ.Inputs.TlsCertMethodArgs
 *         {
 *             Automatic = new AzureNative.IoTOperationsMQ.Inputs.AutomaticCertMethodArgs
 *             {
 *                 Duration = "rv",
 *                 IssuerRef = new AzureNative.IoTOperationsMQ.Inputs.CertManagerIssuerRefArgs
 *                 {
 *                     Group = "wxydv",
 *                     Kind = "birgjwuxfjcvyqe",
 *                     Name = "krmdlovyynymtvgffaveker",
 *                 },
 *                 PrivateKey = new AzureNative.IoTOperationsMQ.Inputs.CertManagerPrivateKeyArgs
 *                 {
 *                     Algorithm = "wwewfsddymjefuhxzqybwvay",
 *                     RotationPolicy = "jxmpyvfneckopjiakjtous",
 *                     Size = 63427,
 *                 },
 *                 RenewBefore = "dexxoqqkgyofhkbk",
 *                 San = new AzureNative.IoTOperationsMQ.Inputs.SanForCertArgs
 *                 {
 *                     Dns = new[]
 *                     {
 *                         "nknzptgqgjvbkgzv",
 *                     },
 *                     Ip = new[]
 *                     {
 *                         "jpdkemham",
 *                     },
 *                 },
 *                 SecretName = "hquvygbuueerkspqqktviya",
 *                 SecretNamespace = "aevwndhcnfxitdjykp",
 *             },
 *             KeyVault = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultCertificatePropertiesArgs
 *             {
 *                 Vault = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultConnectionPropertiesArgs
 *                 {
 *                     Credentials = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultCredentialsPropertiesArgs
 *                     {
 *                         ServicePrincipalLocalSecretName = "wuimjwpbhoglbsxxa",
 *                     },
 *                     DirectoryId = "eyjniptiykzcgbzok",
 *                     Name = "lxmwfan",
 *                 },
 *                 VaultCaChainSecret = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultSecretObjectArgs
 *                 {
 *                     Name = "bmectskddmpjxnsogwooexj",
 *                     Version = "unjfbf",
 *                 },
 *                 VaultCert = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultSecretObjectArgs
 *                 {
 *                     Name = "bmectskddmpjxnsogwooexj",
 *                     Version = "unjfbf",
 *                 },
 *             },
 *             Manual = new AzureNative.IoTOperationsMQ.Inputs.ManualCertMethodArgs
 *             {
 *                 SecretName = "fezcl",
 *                 SecretNamespace = "ozhayajoooingoczovfusqyilin",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/iotoperationsmq/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := iotoperationsmq.NewBrokerListener(ctx, "brokerListener", &iotoperationsmq.BrokerListenerArgs{
 * AuthenticationEnabled: pulumi.Bool(true),
 * AuthorizationEnabled: pulumi.Bool(true),
 * BrokerName: pulumi.String("HGF6WIy6oHv756MjW0JRLILF"),
 * BrokerRef: pulumi.String("ikuszpfycikq"),
 * ExtendedLocation: &iotoperationsmq.ExtendedLocationPropertyArgs{
 * Name: pulumi.String("an"),
 * Type: pulumi.String("CustomLocation"),
 * },
 * ListenerName: pulumi.String("XGEP"),
 * Location: pulumi.String("dppbdcpstouifyko"),
 * MqName: pulumi.String("Z1-2BCdNY4JO--84"),
 * NodePort: pulumi.Int(34375),
 * Port: pulumi.Int(19791),
 * ResourceGroupName: pulumi.String("rgiotoperationsmq"),
 * ServiceName: pulumi.String("euxa"),
 * ServiceType: pulumi.String("clusterIp"),
 * Tags: nil,
 * Tls: iotoperationsmq.TlsCertMethodResponse{
 * Automatic: interface{}{
 * Duration: pulumi.String("rv"),
 * IssuerRef: &iotoperationsmq.CertManagerIssuerRefArgs{
 * Group: pulumi.String("wxydv"),
 * Kind: pulumi.String("birgjwuxfjcvyqe"),
 * Name: pulumi.String("krmdlovyynymtvgffaveker"),
 * },
 * PrivateKey: &iotoperationsmq.CertManagerPrivateKeyArgs{
 * Algorithm: pulumi.String("wwewfsddymjefuhxzqybwvay"),
 * RotationPolicy: pulumi.String("jxmpyvfneckopjiakjtous"),
 * Size: pulumi.Int(63427),
 * },
 * RenewBefore: pulumi.String("dexxoqqkgyofhkbk"),
 * San: &iotoperationsmq.SanForCertArgs{
 * Dns: pulumi.StringArray{
 * pulumi.String("nknzptgqgjvbkgzv"),
 * },
 * Ip: pulumi.StringArray{
 * pulumi.String("jpdkemham"),
 * },
 * },
 * SecretName: pulumi.String("hquvygbuueerkspqqktviya"),
 * SecretNamespace: pulumi.String("aevwndhcnfxitdjykp"),
 * },
 * KeyVault: interface{}{
 * Vault: interface{}{
 * Credentials: &iotoperationsmq.KeyVaultCredentialsPropertiesArgs{
 * ServicePrincipalLocalSecretName: pulumi.String("wuimjwpbhoglbsxxa"),
 * },
 * DirectoryId: pulumi.String("eyjniptiykzcgbzok"),
 * Name: pulumi.String("lxmwfan"),
 * },
 * VaultCaChainSecret: &iotoperationsmq.KeyVaultSecretObjectArgs{
 * Name: pulumi.String("bmectskddmpjxnsogwooexj"),
 * Version: pulumi.String("unjfbf"),
 * },
 * VaultCert: &iotoperationsmq.KeyVaultSecretObjectArgs{
 * Name: pulumi.String("bmectskddmpjxnsogwooexj"),
 * Version: pulumi.String("unjfbf"),
 * },
 * },
 * Manual: &iotoperationsmq.ManualCertMethodArgs{
 * SecretName: pulumi.String("fezcl"),
 * SecretNamespace: pulumi.String("ozhayajoooingoczovfusqyilin"),
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.iotoperationsmq.BrokerListener;
 * import com.pulumi.azurenative.iotoperationsmq.BrokerListenerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var brokerListener = new BrokerListener("brokerListener", BrokerListenerArgs.builder()
 *             .authenticationEnabled(true)
 *             .authorizationEnabled(true)
 *             .brokerName("HGF6WIy6oHv756MjW0JRLILF")
 *             .brokerRef("ikuszpfycikq")
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "an"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .listenerName("XGEP")
 *             .location("dppbdcpstouifyko")
 *             .mqName("Z1-2BCdNY4JO--84")
 *             .nodePort(34375)
 *             .port(19791)
 *             .resourceGroupName("rgiotoperationsmq")
 *             .serviceName("euxa")
 *             .serviceType("clusterIp")
 *             .tags()
 *             .tls(Map.ofEntries(
 *                 Map.entry("automatic", Map.ofEntries(
 *                     Map.entry("duration", "rv"),
 *                     Map.entry("issuerRef", Map.ofEntries(
 *                         Map.entry("group", "wxydv"),
 *                         Map.entry("kind", "birgjwuxfjcvyqe"),
 *                         Map.entry("name", "krmdlovyynymtvgffaveker")
 *                     )),
 *                     Map.entry("privateKey", Map.ofEntries(
 *                         Map.entry("algorithm", "wwewfsddymjefuhxzqybwvay"),
 *                         Map.entry("rotationPolicy", "jxmpyvfneckopjiakjtous"),
 *                         Map.entry("size", 63427)
 *                     )),
 *                     Map.entry("renewBefore", "dexxoqqkgyofhkbk"),
 *                     Map.entry("san", Map.ofEntries(
 *                         Map.entry("dns", "nknzptgqgjvbkgzv"),
 *                         Map.entry("ip", "jpdkemham")
 *                     )),
 *                     Map.entry("secretName", "hquvygbuueerkspqqktviya"),
 *                     Map.entry("secretNamespace", "aevwndhcnfxitdjykp")
 *                 )),
 *                 Map.entry("keyVault", Map.ofEntries(
 *                     Map.entry("vault", Map.ofEntries(
 *                         Map.entry("credentials", Map.of("servicePrincipalLocalSecretName", "wuimjwpbhoglbsxxa")),
 *                         Map.entry("directoryId", "eyjniptiykzcgbzok"),
 *                         Map.entry("name", "lxmwfan")
 *                     )),
 *                     Map.entry("vaultCaChainSecret", Map.ofEntries(
 *                         Map.entry("name", "bmectskddmpjxnsogwooexj"),
 *                         Map.entry("version", "unjfbf")
 *                     )),
 *                     Map.entry("vaultCert", Map.ofEntries(
 *                         Map.entry("name", "bmectskddmpjxnsogwooexj"),
 *                         Map.entry("version", "unjfbf")
 *                     ))
 *                 )),
 *                 Map.entry("manual", Map.ofEntries(
 *                     Map.entry("secretName", "fezcl"),
 *                     Map.entry("secretNamespace", "ozhayajoooingoczovfusqyilin")
 *                 ))
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:iotoperationsmq:BrokerListener ukqwzeflpmangzptkaengwiedlsb /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTOperationsMQ/mq/{mqName}/broker/{brokerName}/listener/{listenerName}
 * ```
 */
public class BrokerListener internal constructor(
    override val javaResource: com.pulumi.azurenative.iotoperationsmq.BrokerListener,
) : KotlinCustomResource(javaResource, BrokerListenerMapper) {
    /**
     * The flag for enabling Authentication rules on Listener Port.
     */
    public val authenticationEnabled: Output<Boolean>?
        get() = javaResource.authenticationEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The flag for enabling Authorization policies on Listener Port. false - AllowAll, true - Use Authorization resource rules if present.
     */
    public val authorizationEnabled: Output<Boolean>?
        get() = javaResource.authorizationEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The k8s cr/resource reference of mq/broker.
     */
    public val brokerRef: Output<String>
        get() = javaResource.brokerRef().applyValue({ args0 -> args0 })

    /**
     * Extended Location
     */
    public val extendedLocation: Output<ExtendedLocationPropertyResponse>
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.let({ args0 ->
                extendedLocationPropertyResponseToKotlin(args0)
            })
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The node port to use on the Host node.
     */
    public val nodePort: Output<Int>?
        get() = javaResource.nodePort().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The port to start Listening for connections on.
     */
    public val port: Output<Int>
        get() = javaResource.port().applyValue({ args0 -> args0 })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The service name to expose Listener port on.
     */
    public val serviceName: Output<String>?
        get() = javaResource.serviceName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Kubernetes Service type to deploy for Listener.
     */
    public val serviceType: Output<String>?
        get() = javaResource.serviceType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Defines configuration of a TLS server certificate. NOTE Enum - Only one TLS Cert method is supported
     */
    public val tls: Output<TlsCertMethodResponse>?
        get() = javaResource.tls().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    tlsCertMethodResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object BrokerListenerMapper : ResourceMapper<BrokerListener> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.iotoperationsmq.BrokerListener::class == javaResource::class

    override fun map(javaResource: Resource): BrokerListener = BrokerListener(
        javaResource as
            com.pulumi.azurenative.iotoperationsmq.BrokerListener,
    )
}

/**
 * @see [BrokerListener].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BrokerListener].
 */
public suspend fun brokerListener(
    name: String,
    block: suspend BrokerListenerResourceBuilder.() -> Unit,
): BrokerListener {
    val builder = BrokerListenerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BrokerListener].
 * @param name The _unique_ name of the resulting resource.
 */
public fun brokerListener(name: String): BrokerListener {
    val builder = BrokerListenerResourceBuilder()
    builder.name(name)
    return builder.build()
}
