@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin

import com.pulumi.azurenative.iotoperationsmq.KafkaConnectorTopicMapArgs.builder
import com.pulumi.azurenative.iotoperationsmq.kotlin.enums.KafkaMessageCompressionType
import com.pulumi.azurenative.iotoperationsmq.kotlin.enums.KafkaPartitionStrategy
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.ExtendedLocationPropertyArgs
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.ExtendedLocationPropertyArgsBuilder
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.KafkaRoutesArgs
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.KafkaRoutesArgsBuilder
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.KafkaTopicMapBatchingArgs
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.KafkaTopicMapBatchingArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * MQ kafkaConnector/topicMap resource
 * Azure REST API version: 2023-10-04-preview.
 * ## Example Usage
 * ### KafkaConnectorTopicMap_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var kafkaConnectorTopicMap = new AzureNative.IoTOperationsMQ.KafkaConnectorTopicMap("kafkaConnectorTopicMap", new()
 *     {
 *         Batching = new AzureNative.IoTOperationsMQ.Inputs.KafkaTopicMapBatchingArgs
 *         {
 *             Enabled = true,
 *             LatencyMs = 9110,
 *             MaxBytes = 732052221,
 *             MaxMessages = 373078076,
 *         },
 *         Compression = "none",
 *         CopyMqttProperties = "efpqgkycuawnzyubdyt",
 *         ExtendedLocation = new AzureNative.IoTOperationsMQ.Inputs.ExtendedLocationPropertyArgs
 *         {
 *             Name = "an",
 *             Type = "CustomLocation",
 *         },
 *         KafkaConnectorName = "216VN",
 *         KafkaConnectorRef = "icivjwerdspx",
 *         Location = "pavphpzfsgdudpyvufyebqh",
 *         MqName = "-1-eD-7-J",
 *         PartitionKeyProperty = "c",
 *         PartitionStrategy = "default",
 *         ResourceGroupName = "rgiotoperationsmq",
 *         Routes = new[]
 *         {
 *             new AzureNative.IoTOperationsMQ.Inputs.KafkaRoutesArgs
 *             {
 *                 KafkaToMqtt = new AzureNative.IoTOperationsMQ.Inputs.KafkaToMqttRoutesArgs
 *                 {
 *                     ConsumerGroupId = "usork",
 *                     KafkaTopic = "ggwhwbsr",
 *                     MqttTopic = "jwvmmhfqqkkmqrpslbdfmpbdetfu",
 *                     Name = "lrnvudysggscnqvmnlkrk",
 *                     Qos = 1,
 *                 },
 *                 MqttToKafka = new AzureNative.IoTOperationsMQ.Inputs.MqttToKafkaRoutesArgs
 *                 {
 *                     KafkaAcks = "zero",
 *                     KafkaTopic = "tellycttwulueqcpqf",
 *                     MqttTopic = "raipkrcwvdnnflywhgjwnquarf",
 *                     Name = "qpshqcaxvxnyjzimvchngupzezdei",
 *                     Qos = 1,
 *                     SharedSubscription = new AzureNative.IoTOperationsMQ.Inputs.KafkaSharedSubscriptionPropertiesArgs
 *                     {
 *                         GroupMinimumShareNumber = 216,
 *                         GroupName = "nwdyccsditzhchuksmi",
 *                     },
 *                 },
 *             },
 *         },
 *         Tags = null,
 *         TopicMapName = "q582ViEY-b7wF1OO2A",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/iotoperationsmq/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iotoperationsmq.NewKafkaConnectorTopicMap(ctx, "kafkaConnectorTopicMap", &iotoperationsmq.KafkaConnectorTopicMapArgs{
 * 			Batching: &iotoperationsmq.KafkaTopicMapBatchingArgs{
 * 				Enabled:     pulumi.Bool(true),
 * 				LatencyMs:   pulumi.Int(9110),
 * 				MaxBytes:    pulumi.Float64(732052221),
 * 				MaxMessages: pulumi.Float64(373078076),
 * 			},
 * 			Compression:        pulumi.String("none"),
 * 			CopyMqttProperties: pulumi.String("efpqgkycuawnzyubdyt"),
 * 			ExtendedLocation: &iotoperationsmq.ExtendedLocationPropertyArgs{
 * 				Name: pulumi.String("an"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			KafkaConnectorName:   pulumi.String("216VN"),
 * 			KafkaConnectorRef:    pulumi.String("icivjwerdspx"),
 * 			Location:             pulumi.String("pavphpzfsgdudpyvufyebqh"),
 * 			MqName:               pulumi.String("-1-eD-7-J"),
 * 			PartitionKeyProperty: pulumi.String("c"),
 * 			PartitionStrategy:    pulumi.String("default"),
 * 			ResourceGroupName:    pulumi.String("rgiotoperationsmq"),
 * 			Routes: []iotoperationsmq.KafkaRoutesArgs{
 * 				{
 * 					KafkaToMqtt: {
 * 						ConsumerGroupId: pulumi.String("usork"),
 * 						KafkaTopic:      pulumi.String("ggwhwbsr"),
 * 						MqttTopic:       pulumi.String("jwvmmhfqqkkmqrpslbdfmpbdetfu"),
 * 						Name:            pulumi.String("lrnvudysggscnqvmnlkrk"),
 * 						Qos:             pulumi.Int(1),
 * 					},
 * 					MqttToKafka: {
 * 						KafkaAcks:  pulumi.String("zero"),
 * 						KafkaTopic: pulumi.String("tellycttwulueqcpqf"),
 * 						MqttTopic:  pulumi.String("raipkrcwvdnnflywhgjwnquarf"),
 * 						Name:       pulumi.String("qpshqcaxvxnyjzimvchngupzezdei"),
 * 						Qos:        pulumi.Int(1),
 * 						SharedSubscription: {
 * 							GroupMinimumShareNumber: pulumi.Int(216),
 * 							GroupName:               pulumi.String("nwdyccsditzhchuksmi"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Tags:         nil,
 * 			TopicMapName: pulumi.String("q582ViEY-b7wF1OO2A"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.iotoperationsmq.KafkaConnectorTopicMap;
 * import com.pulumi.azurenative.iotoperationsmq.KafkaConnectorTopicMapArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var kafkaConnectorTopicMap = new KafkaConnectorTopicMap("kafkaConnectorTopicMap", KafkaConnectorTopicMapArgs.builder()
 *             .batching(Map.ofEntries(
 *                 Map.entry("enabled", true),
 *                 Map.entry("latencyMs", 9110),
 *                 Map.entry("maxBytes", 732052221),
 *                 Map.entry("maxMessages", 373078076)
 *             ))
 *             .compression("none")
 *             .copyMqttProperties("efpqgkycuawnzyubdyt")
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "an"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .kafkaConnectorName("216VN")
 *             .kafkaConnectorRef("icivjwerdspx")
 *             .location("pavphpzfsgdudpyvufyebqh")
 *             .mqName("-1-eD-7-J")
 *             .partitionKeyProperty("c")
 *             .partitionStrategy("default")
 *             .resourceGroupName("rgiotoperationsmq")
 *             .routes(Map.ofEntries(
 *                 Map.entry("kafkaToMqtt", Map.ofEntries(
 *                     Map.entry("consumerGroupId", "usork"),
 *                     Map.entry("kafkaTopic", "ggwhwbsr"),
 *                     Map.entry("mqttTopic", "jwvmmhfqqkkmqrpslbdfmpbdetfu"),
 *                     Map.entry("name", "lrnvudysggscnqvmnlkrk"),
 *                     Map.entry("qos", 1)
 *                 )),
 *                 Map.entry("mqttToKafka", Map.ofEntries(
 *                     Map.entry("kafkaAcks", "zero"),
 *                     Map.entry("kafkaTopic", "tellycttwulueqcpqf"),
 *                     Map.entry("mqttTopic", "raipkrcwvdnnflywhgjwnquarf"),
 *                     Map.entry("name", "qpshqcaxvxnyjzimvchngupzezdei"),
 *                     Map.entry("qos", 1),
 *                     Map.entry("sharedSubscription", Map.ofEntries(
 *                         Map.entry("groupMinimumShareNumber", 216),
 *                         Map.entry("groupName", "nwdyccsditzhchuksmi")
 *                     ))
 *                 ))
 *             ))
 *             .tags()
 *             .topicMapName("q582ViEY-b7wF1OO2A")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:iotoperationsmq:KafkaConnectorTopicMap kdcutfmwzjixcfzbkpelp /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTOperationsMQ/mq/{mqName}/kafkaConnector/{kafkaConnectorName}/topicMap/{topicMapName}
 * ```
 * @property batching The batching settings for kafka messages.
 * @property compression The compression to use for kafka messages.
 * @property copyMqttProperties The flag to copy Mqtt properties.
 * @property extendedLocation Extended Location
 * @property kafkaConnectorName Name of MQ kafkaConnector resource
 * @property kafkaConnectorRef The kafkaConnector CRD it refers to.
 * @property location The geo-location where the resource lives
 * @property mqName Name of MQ resource
 * @property partitionKeyProperty The partition to use for Kafka.
 * @property partitionStrategy The partition strategy to use for Kafka.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property routes The route details for Kafka connector.
 * @property tags Resource tags.
 * @property topicMapName Name of MQ kafka/topicMap resource
 */
public data class KafkaConnectorTopicMapArgs(
    public val batching: Output<KafkaTopicMapBatchingArgs>? = null,
    public val compression: Output<Either<String, KafkaMessageCompressionType>>? = null,
    public val copyMqttProperties: Output<String>? = null,
    public val extendedLocation: Output<ExtendedLocationPropertyArgs>? = null,
    public val kafkaConnectorName: Output<String>? = null,
    public val kafkaConnectorRef: Output<String>? = null,
    public val location: Output<String>? = null,
    public val mqName: Output<String>? = null,
    public val partitionKeyProperty: Output<String>? = null,
    public val partitionStrategy: Output<Either<String, KafkaPartitionStrategy>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val routes: Output<List<KafkaRoutesArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val topicMapName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.KafkaConnectorTopicMapArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.KafkaConnectorTopicMapArgs =
        com.pulumi.azurenative.iotoperationsmq.KafkaConnectorTopicMapArgs.builder()
            .batching(batching?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .compression(
                compression?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .copyMqttProperties(copyMqttProperties?.applyValue({ args0 -> args0 }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kafkaConnectorName(kafkaConnectorName?.applyValue({ args0 -> args0 }))
            .kafkaConnectorRef(kafkaConnectorRef?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .mqName(mqName?.applyValue({ args0 -> args0 }))
            .partitionKeyProperty(partitionKeyProperty?.applyValue({ args0 -> args0 }))
            .partitionStrategy(
                partitionStrategy?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .routes(routes?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .topicMapName(topicMapName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KafkaConnectorTopicMapArgs].
 */
@PulumiTagMarker
public class KafkaConnectorTopicMapArgsBuilder internal constructor() {
    private var batching: Output<KafkaTopicMapBatchingArgs>? = null

    private var compression: Output<Either<String, KafkaMessageCompressionType>>? = null

    private var copyMqttProperties: Output<String>? = null

    private var extendedLocation: Output<ExtendedLocationPropertyArgs>? = null

    private var kafkaConnectorName: Output<String>? = null

    private var kafkaConnectorRef: Output<String>? = null

    private var location: Output<String>? = null

    private var mqName: Output<String>? = null

    private var partitionKeyProperty: Output<String>? = null

    private var partitionStrategy: Output<Either<String, KafkaPartitionStrategy>>? = null

    private var resourceGroupName: Output<String>? = null

    private var routes: Output<List<KafkaRoutesArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var topicMapName: Output<String>? = null

    /**
     * @param value The batching settings for kafka messages.
     */
    @JvmName("ippjcujuufywdbvo")
    public suspend fun batching(`value`: Output<KafkaTopicMapBatchingArgs>) {
        this.batching = value
    }

    /**
     * @param value The compression to use for kafka messages.
     */
    @JvmName("sqybdtbbyrjkjqvg")
    public suspend fun compression(`value`: Output<Either<String, KafkaMessageCompressionType>>) {
        this.compression = value
    }

    /**
     * @param value The flag to copy Mqtt properties.
     */
    @JvmName("bbtxxqockwejsehh")
    public suspend fun copyMqttProperties(`value`: Output<String>) {
        this.copyMqttProperties = value
    }

    /**
     * @param value Extended Location
     */
    @JvmName("udwccnbvgmfymcaf")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationPropertyArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value Name of MQ kafkaConnector resource
     */
    @JvmName("eashsoklvpgiommr")
    public suspend fun kafkaConnectorName(`value`: Output<String>) {
        this.kafkaConnectorName = value
    }

    /**
     * @param value The kafkaConnector CRD it refers to.
     */
    @JvmName("vvmwrdedfbrficrv")
    public suspend fun kafkaConnectorRef(`value`: Output<String>) {
        this.kafkaConnectorRef = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("uupresdakdrrfkdr")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of MQ resource
     */
    @JvmName("iwyqgyvnhiwwqjkf")
    public suspend fun mqName(`value`: Output<String>) {
        this.mqName = value
    }

    /**
     * @param value The partition to use for Kafka.
     */
    @JvmName("ndpkkokyrublxjnv")
    public suspend fun partitionKeyProperty(`value`: Output<String>) {
        this.partitionKeyProperty = value
    }

    /**
     * @param value The partition strategy to use for Kafka.
     */
    @JvmName("sgumdghfrymjgrvi")
    public suspend fun partitionStrategy(`value`: Output<Either<String, KafkaPartitionStrategy>>) {
        this.partitionStrategy = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("nsndiwtvyhoqibtw")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The route details for Kafka connector.
     */
    @JvmName("aqtyiqqslcqdkchl")
    public suspend fun routes(`value`: Output<List<KafkaRoutesArgs>>) {
        this.routes = value
    }

    @JvmName("vgbbaolhdndppcwv")
    public suspend fun routes(vararg values: Output<KafkaRoutesArgs>) {
        this.routes = Output.all(values.asList())
    }

    /**
     * @param values The route details for Kafka connector.
     */
    @JvmName("nubewpfmuuuslooh")
    public suspend fun routes(values: List<Output<KafkaRoutesArgs>>) {
        this.routes = Output.all(values)
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("bgpnwckpxtlgujfn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of MQ kafka/topicMap resource
     */
    @JvmName("svduwuiyqvjjnuop")
    public suspend fun topicMapName(`value`: Output<String>) {
        this.topicMapName = value
    }

    /**
     * @param value The batching settings for kafka messages.
     */
    @JvmName("exebnktmylwpfykh")
    public suspend fun batching(`value`: KafkaTopicMapBatchingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.batching = mapped
    }

    /**
     * @param argument The batching settings for kafka messages.
     */
    @JvmName("avatyrpfaugrrcos")
    public suspend fun batching(argument: suspend KafkaTopicMapBatchingArgsBuilder.() -> Unit) {
        val toBeMapped = KafkaTopicMapBatchingArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.batching = mapped
    }

    /**
     * @param value The compression to use for kafka messages.
     */
    @JvmName("dwbouxexqeywnwrk")
    public suspend fun compression(`value`: Either<String, KafkaMessageCompressionType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.compression = mapped
    }

    /**
     * @param value The compression to use for kafka messages.
     */
    @JvmName("pvdxmdwyfavoloye")
    public fun compression(`value`: String) {
        val toBeMapped = Either.ofLeft<String, KafkaMessageCompressionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.compression = mapped
    }

    /**
     * @param value The compression to use for kafka messages.
     */
    @JvmName("wflrbxyblvqxjwgm")
    public fun compression(`value`: KafkaMessageCompressionType) {
        val toBeMapped = Either.ofRight<String, KafkaMessageCompressionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.compression = mapped
    }

    /**
     * @param value The flag to copy Mqtt properties.
     */
    @JvmName("hxpotligeqkkhdel")
    public suspend fun copyMqttProperties(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.copyMqttProperties = mapped
    }

    /**
     * @param value Extended Location
     */
    @JvmName("jxhuifibqjommejg")
    public suspend fun extendedLocation(`value`: ExtendedLocationPropertyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument Extended Location
     */
    @JvmName("drgexynonxifjdkd")
    public suspend
    fun extendedLocation(argument: suspend ExtendedLocationPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationPropertyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value Name of MQ kafkaConnector resource
     */
    @JvmName("ujqbubshyevpeofy")
    public suspend fun kafkaConnectorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kafkaConnectorName = mapped
    }

    /**
     * @param value The kafkaConnector CRD it refers to.
     */
    @JvmName("stigibksxkhaeudv")
    public suspend fun kafkaConnectorRef(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kafkaConnectorRef = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("jqmrvaiqpmhnwomm")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of MQ resource
     */
    @JvmName("acmymnortxxskxnr")
    public suspend fun mqName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mqName = mapped
    }

    /**
     * @param value The partition to use for Kafka.
     */
    @JvmName("dwolurenrdayejhc")
    public suspend fun partitionKeyProperty(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionKeyProperty = mapped
    }

    /**
     * @param value The partition strategy to use for Kafka.
     */
    @JvmName("ifyqiyvgiquymhkj")
    public suspend fun partitionStrategy(`value`: Either<String, KafkaPartitionStrategy>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionStrategy = mapped
    }

    /**
     * @param value The partition strategy to use for Kafka.
     */
    @JvmName("mmrhufyreufkdufu")
    public fun partitionStrategy(`value`: String) {
        val toBeMapped = Either.ofLeft<String, KafkaPartitionStrategy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.partitionStrategy = mapped
    }

    /**
     * @param value The partition strategy to use for Kafka.
     */
    @JvmName("viwowgxhtdceyncv")
    public fun partitionStrategy(`value`: KafkaPartitionStrategy) {
        val toBeMapped = Either.ofRight<String, KafkaPartitionStrategy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.partitionStrategy = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("pugcdboxmatabary")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The route details for Kafka connector.
     */
    @JvmName("iumtscufantevgow")
    public suspend fun routes(`value`: List<KafkaRoutesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routes = mapped
    }

    /**
     * @param argument The route details for Kafka connector.
     */
    @JvmName("gqwoiaafbbaduujt")
    public suspend fun routes(argument: List<suspend KafkaRoutesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { KafkaRoutesArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.routes = mapped
    }

    /**
     * @param argument The route details for Kafka connector.
     */
    @JvmName("vplixwcddsyditpj")
    public suspend fun routes(vararg argument: suspend KafkaRoutesArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { KafkaRoutesArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.routes = mapped
    }

    /**
     * @param argument The route details for Kafka connector.
     */
    @JvmName("xpbuiucclxfibbkb")
    public suspend fun routes(argument: suspend KafkaRoutesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(KafkaRoutesArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.routes = mapped
    }

    /**
     * @param values The route details for Kafka connector.
     */
    @JvmName("gjptiilnepuathpy")
    public suspend fun routes(vararg values: KafkaRoutesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routes = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("hvqgkkypijaeitug")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("fuppvbeuybifqwyv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Name of MQ kafka/topicMap resource
     */
    @JvmName("lettiacqjjyojsij")
    public suspend fun topicMapName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.topicMapName = mapped
    }

    internal fun build(): KafkaConnectorTopicMapArgs = KafkaConnectorTopicMapArgs(
        batching = batching,
        compression = compression,
        copyMqttProperties = copyMqttProperties,
        extendedLocation = extendedLocation,
        kafkaConnectorName = kafkaConnectorName,
        kafkaConnectorRef = kafkaConnectorRef,
        location = location,
        mqName = mqName,
        partitionKeyProperty = partitionKeyProperty,
        partitionStrategy = partitionStrategy,
        resourceGroupName = resourceGroupName,
        routes = routes,
        tags = tags,
        topicMapName = topicMapName,
    )
}
