@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The compression to use for kafka messages.
 */
public enum class KafkaMessageCompressionType(
    public val javaValue: com.pulumi.azurenative.iotoperationsmq.enums.KafkaMessageCompressionType,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.enums.KafkaMessageCompressionType> {
    /**
     * No Kafka message compression.
     */
    None(com.pulumi.azurenative.iotoperationsmq.enums.KafkaMessageCompressionType.None),

    /**
     * Gzip Kafka message compression.
     */
    Gzip(com.pulumi.azurenative.iotoperationsmq.enums.KafkaMessageCompressionType.Gzip),

    /**
     * Snappy Kafka message compression.
     */
    Snappy(com.pulumi.azurenative.iotoperationsmq.enums.KafkaMessageCompressionType.Snappy),

    /**
     * Lz4 Kafka message compression.
     */
    Lz4(com.pulumi.azurenative.iotoperationsmq.enums.KafkaMessageCompressionType.Lz4),
    ;

    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.enums.KafkaMessageCompressionType =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.enums.KafkaMessageCompressionType):
            KafkaMessageCompressionType =
            KafkaMessageCompressionType.values().first { it.javaValue == javaType }
    }
}
