@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The partition strategy to use for Kafka.
 */
public enum class KafkaPartitionStrategy(
    public val javaValue: com.pulumi.azurenative.iotoperationsmq.enums.KafkaPartitionStrategy,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.enums.KafkaPartitionStrategy> {
    /**
     * Default partition strategy.
     */
    Default_(com.pulumi.azurenative.iotoperationsmq.enums.KafkaPartitionStrategy.Default_),

    /**
     * Static partition strategy.
     */
    Static_(com.pulumi.azurenative.iotoperationsmq.enums.KafkaPartitionStrategy.Static_),

    /**
     * Topic partition strategy.
     */
    Topic(com.pulumi.azurenative.iotoperationsmq.enums.KafkaPartitionStrategy.Topic),

    /**
     * Property partition strategy.
     */
    Property(com.pulumi.azurenative.iotoperationsmq.enums.KafkaPartitionStrategy.Property),
    ;

    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.enums.KafkaPartitionStrategy =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.enums.KafkaPartitionStrategy):
            KafkaPartitionStrategy = KafkaPartitionStrategy.values().first { it.javaValue == javaType }
    }
}
