@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Sasl Mechanism for remote broker authentication.
 */
public enum class KafkaSaslType(
    public val javaValue: com.pulumi.azurenative.iotoperationsmq.enums.KafkaSaslType,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.enums.KafkaSaslType> {
    /**
     * Sasl Plain authentication.
     */
    Plain(com.pulumi.azurenative.iotoperationsmq.enums.KafkaSaslType.Plain),

    /**
     * Sasl ScramSha256 authentication.
     */
    ScramSha256(com.pulumi.azurenative.iotoperationsmq.enums.KafkaSaslType.ScramSha256),

    /**
     * Sasl ScramSha512 authentication.
     */
    ScramSha512(com.pulumi.azurenative.iotoperationsmq.enums.KafkaSaslType.ScramSha512),
    ;

    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.enums.KafkaSaslType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.enums.KafkaSaslType):
            KafkaSaslType = KafkaSaslType.values().first { it.javaValue == javaType }
    }
}
