@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.BrokerAuthenticatorCustomAuthX509Args.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * X509 Custom Authentication properties. NOTE - Enum only authenticator type supported at a time.
 * @property keyVault Keyvault X509 secret properties.
 * @property secretName Secret where cert details are stored.
 */
public data class BrokerAuthenticatorCustomAuthX509Args(
    public val keyVault: Output<KeyVaultCertificatePropertiesArgs>? = null,
    public val secretName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.BrokerAuthenticatorCustomAuthX509Args> {
    override fun toJava():
        com.pulumi.azurenative.iotoperationsmq.inputs.BrokerAuthenticatorCustomAuthX509Args =
        com.pulumi.azurenative.iotoperationsmq.inputs.BrokerAuthenticatorCustomAuthX509Args.builder()
            .keyVault(keyVault?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .secretName(secretName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BrokerAuthenticatorCustomAuthX509Args].
 */
@PulumiTagMarker
public class BrokerAuthenticatorCustomAuthX509ArgsBuilder internal constructor() {
    private var keyVault: Output<KeyVaultCertificatePropertiesArgs>? = null

    private var secretName: Output<String>? = null

    /**
     * @param value Keyvault X509 secret properties.
     */
    @JvmName("euvrmssostjvotwy")
    public suspend fun keyVault(`value`: Output<KeyVaultCertificatePropertiesArgs>) {
        this.keyVault = value
    }

    /**
     * @param value Secret where cert details are stored.
     */
    @JvmName("ndktdijuxxhiqqju")
    public suspend fun secretName(`value`: Output<String>) {
        this.secretName = value
    }

    /**
     * @param value Keyvault X509 secret properties.
     */
    @JvmName("maaffgvjjvqtkcev")
    public suspend fun keyVault(`value`: KeyVaultCertificatePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVault = mapped
    }

    /**
     * @param argument Keyvault X509 secret properties.
     */
    @JvmName("rgepbqypicqyttal")
    public suspend
    fun keyVault(argument: suspend KeyVaultCertificatePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = KeyVaultCertificatePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.keyVault = mapped
    }

    /**
     * @param value Secret where cert details are stored.
     */
    @JvmName("yqqoclsnevjuxssw")
    public suspend fun secretName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretName = mapped
    }

    internal fun build(): BrokerAuthenticatorCustomAuthX509Args =
        BrokerAuthenticatorCustomAuthX509Args(
            keyVault = keyVault,
            secretName = secretName,
        )
}
