@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.BrokerDiagnosticsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Diagnostics setting specific to Broker
 * @property diagnosticServiceEndpoint Diagnostic Service endpoint
 * @property enableMetrics Knob to enable/disable metrics. Default = true
 * @property enableSelfCheck Enable self check on Broker via Probe.
 * @property enableSelfTracing Enable self tracing on the Broker so that every selfCheckFrequencySeconds a random message is traced even if it didn't have trace context.
 * @property enableTracing Knob to enable/disable entire tracing infrastructure.
 * @property logFormat Format for the logs generated.
 * @property logLevel Log level for the Broker.
 * @property maxCellMapLifetime Maximum time for the CellMap to live.
 * @property metricUpdateFrequencySeconds Metric update frequency in seconds.
 * @property probeImage Probe Image to run.
 * @property selfCheckFrequencySeconds Frequency for the self check to run.
 * @property selfCheckTimeoutSeconds Time out period of the self check.
 * @property selfTraceFrequencySeconds The frequency at which selfTrace should run.
 * @property spanChannelCapacity The number of the spans generated by the Tracing.
 */
public data class BrokerDiagnosticsArgs(
    public val diagnosticServiceEndpoint: Output<String>? = null,
    public val enableMetrics: Output<Boolean>? = null,
    public val enableSelfCheck: Output<Boolean>? = null,
    public val enableSelfTracing: Output<Boolean>? = null,
    public val enableTracing: Output<Boolean>? = null,
    public val logFormat: Output<String>? = null,
    public val logLevel: Output<String>? = null,
    public val maxCellMapLifetime: Output<Double>? = null,
    public val metricUpdateFrequencySeconds: Output<Double>? = null,
    public val probeImage: Output<String>? = null,
    public val selfCheckFrequencySeconds: Output<Double>? = null,
    public val selfCheckTimeoutSeconds: Output<Double>? = null,
    public val selfTraceFrequencySeconds: Output<Double>? = null,
    public val spanChannelCapacity: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.BrokerDiagnosticsArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.inputs.BrokerDiagnosticsArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.BrokerDiagnosticsArgs.builder()
            .diagnosticServiceEndpoint(diagnosticServiceEndpoint?.applyValue({ args0 -> args0 }))
            .enableMetrics(enableMetrics?.applyValue({ args0 -> args0 }))
            .enableSelfCheck(enableSelfCheck?.applyValue({ args0 -> args0 }))
            .enableSelfTracing(enableSelfTracing?.applyValue({ args0 -> args0 }))
            .enableTracing(enableTracing?.applyValue({ args0 -> args0 }))
            .logFormat(logFormat?.applyValue({ args0 -> args0 }))
            .logLevel(logLevel?.applyValue({ args0 -> args0 }))
            .maxCellMapLifetime(maxCellMapLifetime?.applyValue({ args0 -> args0 }))
            .metricUpdateFrequencySeconds(metricUpdateFrequencySeconds?.applyValue({ args0 -> args0 }))
            .probeImage(probeImage?.applyValue({ args0 -> args0 }))
            .selfCheckFrequencySeconds(selfCheckFrequencySeconds?.applyValue({ args0 -> args0 }))
            .selfCheckTimeoutSeconds(selfCheckTimeoutSeconds?.applyValue({ args0 -> args0 }))
            .selfTraceFrequencySeconds(selfTraceFrequencySeconds?.applyValue({ args0 -> args0 }))
            .spanChannelCapacity(spanChannelCapacity?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BrokerDiagnosticsArgs].
 */
@PulumiTagMarker
public class BrokerDiagnosticsArgsBuilder internal constructor() {
    private var diagnosticServiceEndpoint: Output<String>? = null

    private var enableMetrics: Output<Boolean>? = null

    private var enableSelfCheck: Output<Boolean>? = null

    private var enableSelfTracing: Output<Boolean>? = null

    private var enableTracing: Output<Boolean>? = null

    private var logFormat: Output<String>? = null

    private var logLevel: Output<String>? = null

    private var maxCellMapLifetime: Output<Double>? = null

    private var metricUpdateFrequencySeconds: Output<Double>? = null

    private var probeImage: Output<String>? = null

    private var selfCheckFrequencySeconds: Output<Double>? = null

    private var selfCheckTimeoutSeconds: Output<Double>? = null

    private var selfTraceFrequencySeconds: Output<Double>? = null

    private var spanChannelCapacity: Output<Double>? = null

    /**
     * @param value Diagnostic Service endpoint
     */
    @JvmName("rxxxwjblgynmlxlq")
    public suspend fun diagnosticServiceEndpoint(`value`: Output<String>) {
        this.diagnosticServiceEndpoint = value
    }

    /**
     * @param value Knob to enable/disable metrics. Default = true
     */
    @JvmName("ltewinrnblofpebh")
    public suspend fun enableMetrics(`value`: Output<Boolean>) {
        this.enableMetrics = value
    }

    /**
     * @param value Enable self check on Broker via Probe.
     */
    @JvmName("noilrboogsumniic")
    public suspend fun enableSelfCheck(`value`: Output<Boolean>) {
        this.enableSelfCheck = value
    }

    /**
     * @param value Enable self tracing on the Broker so that every selfCheckFrequencySeconds a random message is traced even if it didn't have trace context.
     */
    @JvmName("lmnqxljvegxkxowd")
    public suspend fun enableSelfTracing(`value`: Output<Boolean>) {
        this.enableSelfTracing = value
    }

    /**
     * @param value Knob to enable/disable entire tracing infrastructure.
     */
    @JvmName("rwofcorbkloxaewj")
    public suspend fun enableTracing(`value`: Output<Boolean>) {
        this.enableTracing = value
    }

    /**
     * @param value Format for the logs generated.
     */
    @JvmName("ismnscsmqtltjbqp")
    public suspend fun logFormat(`value`: Output<String>) {
        this.logFormat = value
    }

    /**
     * @param value Log level for the Broker.
     */
    @JvmName("hmhhtkcjfxrxjnqk")
    public suspend fun logLevel(`value`: Output<String>) {
        this.logLevel = value
    }

    /**
     * @param value Maximum time for the CellMap to live.
     */
    @JvmName("affghbodhkayufml")
    public suspend fun maxCellMapLifetime(`value`: Output<Double>) {
        this.maxCellMapLifetime = value
    }

    /**
     * @param value Metric update frequency in seconds.
     */
    @JvmName("hlaancfvtmgmoyna")
    public suspend fun metricUpdateFrequencySeconds(`value`: Output<Double>) {
        this.metricUpdateFrequencySeconds = value
    }

    /**
     * @param value Probe Image to run.
     */
    @JvmName("wlsabahrqbmwkgeb")
    public suspend fun probeImage(`value`: Output<String>) {
        this.probeImage = value
    }

    /**
     * @param value Frequency for the self check to run.
     */
    @JvmName("rohunoapiktvcnbm")
    public suspend fun selfCheckFrequencySeconds(`value`: Output<Double>) {
        this.selfCheckFrequencySeconds = value
    }

    /**
     * @param value Time out period of the self check.
     */
    @JvmName("esyndjqrrlrtkaqv")
    public suspend fun selfCheckTimeoutSeconds(`value`: Output<Double>) {
        this.selfCheckTimeoutSeconds = value
    }

    /**
     * @param value The frequency at which selfTrace should run.
     */
    @JvmName("hxoyjgtbafaryean")
    public suspend fun selfTraceFrequencySeconds(`value`: Output<Double>) {
        this.selfTraceFrequencySeconds = value
    }

    /**
     * @param value The number of the spans generated by the Tracing.
     */
    @JvmName("uqqvwkntoinrlrrj")
    public suspend fun spanChannelCapacity(`value`: Output<Double>) {
        this.spanChannelCapacity = value
    }

    /**
     * @param value Diagnostic Service endpoint
     */
    @JvmName("kcmsagvkuhmffqiv")
    public suspend fun diagnosticServiceEndpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diagnosticServiceEndpoint = mapped
    }

    /**
     * @param value Knob to enable/disable metrics. Default = true
     */
    @JvmName("jwdchhvygjhalqwm")
    public suspend fun enableMetrics(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableMetrics = mapped
    }

    /**
     * @param value Enable self check on Broker via Probe.
     */
    @JvmName("awgbroctihykclkj")
    public suspend fun enableSelfCheck(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableSelfCheck = mapped
    }

    /**
     * @param value Enable self tracing on the Broker so that every selfCheckFrequencySeconds a random message is traced even if it didn't have trace context.
     */
    @JvmName("uskfkoxevylnfeba")
    public suspend fun enableSelfTracing(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableSelfTracing = mapped
    }

    /**
     * @param value Knob to enable/disable entire tracing infrastructure.
     */
    @JvmName("fvggwqumgflkfawb")
    public suspend fun enableTracing(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableTracing = mapped
    }

    /**
     * @param value Format for the logs generated.
     */
    @JvmName("iqvxhxkkbpwjmmtw")
    public suspend fun logFormat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logFormat = mapped
    }

    /**
     * @param value Log level for the Broker.
     */
    @JvmName("tlwgcmdgrnmcstxr")
    public suspend fun logLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logLevel = mapped
    }

    /**
     * @param value Maximum time for the CellMap to live.
     */
    @JvmName("gknntkpgtungdwen")
    public suspend fun maxCellMapLifetime(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxCellMapLifetime = mapped
    }

    /**
     * @param value Metric update frequency in seconds.
     */
    @JvmName("sojrnloiygshvydk")
    public suspend fun metricUpdateFrequencySeconds(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricUpdateFrequencySeconds = mapped
    }

    /**
     * @param value Probe Image to run.
     */
    @JvmName("vcirqyxhpkhepcha")
    public suspend fun probeImage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.probeImage = mapped
    }

    /**
     * @param value Frequency for the self check to run.
     */
    @JvmName("wjdrliekjhpxriuk")
    public suspend fun selfCheckFrequencySeconds(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.selfCheckFrequencySeconds = mapped
    }

    /**
     * @param value Time out period of the self check.
     */
    @JvmName("qkotmqijldxhfviq")
    public suspend fun selfCheckTimeoutSeconds(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.selfCheckTimeoutSeconds = mapped
    }

    /**
     * @param value The frequency at which selfTrace should run.
     */
    @JvmName("jhkcsghdskjubyyj")
    public suspend fun selfTraceFrequencySeconds(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.selfTraceFrequencySeconds = mapped
    }

    /**
     * @param value The number of the spans generated by the Tracing.
     */
    @JvmName("gvjkdwhwmoofsrrw")
    public suspend fun spanChannelCapacity(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spanChannelCapacity = mapped
    }

    internal fun build(): BrokerDiagnosticsArgs = BrokerDiagnosticsArgs(
        diagnosticServiceEndpoint = diagnosticServiceEndpoint,
        enableMetrics = enableMetrics,
        enableSelfCheck = enableSelfCheck,
        enableSelfTracing = enableSelfTracing,
        enableTracing = enableTracing,
        logFormat = logFormat,
        logLevel = logLevel,
        maxCellMapLifetime = maxCellMapLifetime,
        metricUpdateFrequencySeconds = metricUpdateFrequencySeconds,
        probeImage = probeImage,
        selfCheckFrequencySeconds = selfCheckFrequencySeconds,
        selfCheckTimeoutSeconds = selfCheckTimeoutSeconds,
        selfTraceFrequencySeconds = selfTraceFrequencySeconds,
        spanChannelCapacity = spanChannelCapacity,
    )
}
