@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.CertManagerIssuerRefArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Cert-Manager issuerRef properties
 * @property group group of issuer.
 * @property kind kind of issuer (Issuer or ClusterIssuer).
 * @property name name of issuer.
 */
public data class CertManagerIssuerRefArgs(
    public val group: Output<String>,
    public val kind: Output<String>,
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.CertManagerIssuerRefArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.inputs.CertManagerIssuerRefArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.CertManagerIssuerRefArgs.builder()
            .group(group.applyValue({ args0 -> args0 }))
            .kind(kind.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CertManagerIssuerRefArgs].
 */
@PulumiTagMarker
public class CertManagerIssuerRefArgsBuilder internal constructor() {
    private var group: Output<String>? = null

    private var kind: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value group of issuer.
     */
    @JvmName("khwsslgqnttiuddl")
    public suspend fun group(`value`: Output<String>) {
        this.group = value
    }

    /**
     * @param value kind of issuer (Issuer or ClusterIssuer).
     */
    @JvmName("geqvsytkbeeuouhd")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value name of issuer.
     */
    @JvmName("ebdkblkbtvucdgpe")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value group of issuer.
     */
    @JvmName("jdxheufokspgkgyv")
    public suspend fun group(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.group = mapped
    }

    /**
     * @param value kind of issuer (Issuer or ClusterIssuer).
     */
    @JvmName("epwawnbvdmocgnpq")
    public suspend fun kind(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value name of issuer.
     */
    @JvmName("xofavxsyjpieldet")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): CertManagerIssuerRefArgs = CertManagerIssuerRefArgs(
        group = group ?: throw PulumiNullFieldException("group"),
        kind = kind ?: throw PulumiNullFieldException("kind"),
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
