@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.CertManagerPrivateKeyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Cert Manager private key properties
 * @property algorithm algorithm for private key.
 * @property rotationPolicy cert-manager rotationPolicy.
 * @property size size of private key.
 */
public data class CertManagerPrivateKeyArgs(
    public val algorithm: Output<String>,
    public val rotationPolicy: Output<String>,
    public val size: Output<Int>,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.CertManagerPrivateKeyArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.inputs.CertManagerPrivateKeyArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.CertManagerPrivateKeyArgs.builder()
            .algorithm(algorithm.applyValue({ args0 -> args0 }))
            .rotationPolicy(rotationPolicy.applyValue({ args0 -> args0 }))
            .size(size.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CertManagerPrivateKeyArgs].
 */
@PulumiTagMarker
public class CertManagerPrivateKeyArgsBuilder internal constructor() {
    private var algorithm: Output<String>? = null

    private var rotationPolicy: Output<String>? = null

    private var size: Output<Int>? = null

    /**
     * @param value algorithm for private key.
     */
    @JvmName("uvldxxtwuwqkutcc")
    public suspend fun algorithm(`value`: Output<String>) {
        this.algorithm = value
    }

    /**
     * @param value cert-manager rotationPolicy.
     */
    @JvmName("lsymepknghlxqycs")
    public suspend fun rotationPolicy(`value`: Output<String>) {
        this.rotationPolicy = value
    }

    /**
     * @param value size of private key.
     */
    @JvmName("wminypywcfcjyjsu")
    public suspend fun size(`value`: Output<Int>) {
        this.size = value
    }

    /**
     * @param value algorithm for private key.
     */
    @JvmName("vkqpqsxfrnlhbjui")
    public suspend fun algorithm(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.algorithm = mapped
    }

    /**
     * @param value cert-manager rotationPolicy.
     */
    @JvmName("irnktafmfbuurhcd")
    public suspend fun rotationPolicy(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rotationPolicy = mapped
    }

    /**
     * @param value size of private key.
     */
    @JvmName("ieaaephcbdvrvfpf")
    public suspend fun size(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.size = mapped
    }

    internal fun build(): CertManagerPrivateKeyArgs = CertManagerPrivateKeyArgs(
        algorithm = algorithm ?: throw PulumiNullFieldException("algorithm"),
        rotationPolicy = rotationPolicy ?: throw PulumiNullFieldException("rotationPolicy"),
        size = size ?: throw PulumiNullFieldException("size"),
    )
}
