@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.DataLakeConnectorMapArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * DataLake connector map route properties
 * @property allowedLatencySecs Allowed latency for transferring data.
 * @property clientId Client Id to use.
 * @property maxMessagesPerBatch Maximum messages to send per Batch.
 * @property messagePayloadType Message payload type.
 * @property mqttSourceTopic Mqtt source topic.
 * @property qos Quality of Service.
 * @property table Delta table properties to use.
 */
public data class DataLakeConnectorMapArgs(
    public val allowedLatencySecs: Output<Int>,
    public val clientId: Output<String>,
    public val maxMessagesPerBatch: Output<Double>,
    public val messagePayloadType: Output<String>,
    public val mqttSourceTopic: Output<String>,
    public val qos: Output<Int>? = null,
    public val table: Output<DeltaTableArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.DataLakeConnectorMapArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.inputs.DataLakeConnectorMapArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.DataLakeConnectorMapArgs.builder()
            .allowedLatencySecs(allowedLatencySecs.applyValue({ args0 -> args0 }))
            .clientId(clientId.applyValue({ args0 -> args0 }))
            .maxMessagesPerBatch(maxMessagesPerBatch.applyValue({ args0 -> args0 }))
            .messagePayloadType(messagePayloadType.applyValue({ args0 -> args0 }))
            .mqttSourceTopic(mqttSourceTopic.applyValue({ args0 -> args0 }))
            .qos(qos?.applyValue({ args0 -> args0 }))
            .table(table.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DataLakeConnectorMapArgs].
 */
@PulumiTagMarker
public class DataLakeConnectorMapArgsBuilder internal constructor() {
    private var allowedLatencySecs: Output<Int>? = null

    private var clientId: Output<String>? = null

    private var maxMessagesPerBatch: Output<Double>? = null

    private var messagePayloadType: Output<String>? = null

    private var mqttSourceTopic: Output<String>? = null

    private var qos: Output<Int>? = null

    private var table: Output<DeltaTableArgs>? = null

    /**
     * @param value Allowed latency for transferring data.
     */
    @JvmName("vismnlptyquoueul")
    public suspend fun allowedLatencySecs(`value`: Output<Int>) {
        this.allowedLatencySecs = value
    }

    /**
     * @param value Client Id to use.
     */
    @JvmName("xoxbalvchkdelhqy")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value Maximum messages to send per Batch.
     */
    @JvmName("tpsbekwehpfummbx")
    public suspend fun maxMessagesPerBatch(`value`: Output<Double>) {
        this.maxMessagesPerBatch = value
    }

    /**
     * @param value Message payload type.
     */
    @JvmName("lskbqwrcbbdrovkr")
    public suspend fun messagePayloadType(`value`: Output<String>) {
        this.messagePayloadType = value
    }

    /**
     * @param value Mqtt source topic.
     */
    @JvmName("filwyhrbplqfbyoh")
    public suspend fun mqttSourceTopic(`value`: Output<String>) {
        this.mqttSourceTopic = value
    }

    /**
     * @param value Quality of Service.
     */
    @JvmName("gnycxbulllirilib")
    public suspend fun qos(`value`: Output<Int>) {
        this.qos = value
    }

    /**
     * @param value Delta table properties to use.
     */
    @JvmName("cklnjwwfyrhwqtwx")
    public suspend fun table(`value`: Output<DeltaTableArgs>) {
        this.table = value
    }

    /**
     * @param value Allowed latency for transferring data.
     */
    @JvmName("mslnvpeslqbtmnvk")
    public suspend fun allowedLatencySecs(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedLatencySecs = mapped
    }

    /**
     * @param value Client Id to use.
     */
    @JvmName("dllychffgcjxbotm")
    public suspend fun clientId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value Maximum messages to send per Batch.
     */
    @JvmName("idsvhudiewabmbiu")
    public suspend fun maxMessagesPerBatch(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxMessagesPerBatch = mapped
    }

    /**
     * @param value Message payload type.
     */
    @JvmName("gdypxsynrdjbgrpx")
    public suspend fun messagePayloadType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.messagePayloadType = mapped
    }

    /**
     * @param value Mqtt source topic.
     */
    @JvmName("ncrsuixqrgqfwhxs")
    public suspend fun mqttSourceTopic(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mqttSourceTopic = mapped
    }

    /**
     * @param value Quality of Service.
     */
    @JvmName("qrhecnqgcqrolecw")
    public suspend fun qos(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.qos = mapped
    }

    /**
     * @param value Delta table properties to use.
     */
    @JvmName("hxuwqlxutuyknqwt")
    public suspend fun table(`value`: DeltaTableArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.table = mapped
    }

    /**
     * @param argument Delta table properties to use.
     */
    @JvmName("wkyheiecqppsjhss")
    public suspend fun table(argument: suspend DeltaTableArgsBuilder.() -> Unit) {
        val toBeMapped = DeltaTableArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.table = mapped
    }

    internal fun build(): DataLakeConnectorMapArgs = DataLakeConnectorMapArgs(
        allowedLatencySecs = allowedLatencySecs ?: throw PulumiNullFieldException("allowedLatencySecs"),
        clientId = clientId ?: throw PulumiNullFieldException("clientId"),
        maxMessagesPerBatch = maxMessagesPerBatch ?: throw PulumiNullFieldException("maxMessagesPerBatch"),
        messagePayloadType = messagePayloadType ?: throw PulumiNullFieldException("messagePayloadType"),
        mqttSourceTopic = mqttSourceTopic ?: throw PulumiNullFieldException("mqttSourceTopic"),
        qos = qos,
        table = table ?: throw PulumiNullFieldException("table"),
    )
}
