@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.DataLakeFabricStorageAuthenticationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * DataLake Fabric Storage authentication details.
 * @property systemAssignedManagedIdentity Configuration for managed identity authentication.
 */
public data class DataLakeFabricStorageAuthenticationArgs(
    public val systemAssignedManagedIdentity: Output<ManagedIdentityAuthenticationArgs>,
) :
    ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.DataLakeFabricStorageAuthenticationArgs> {
    override fun toJava():
        com.pulumi.azurenative.iotoperationsmq.inputs.DataLakeFabricStorageAuthenticationArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.DataLakeFabricStorageAuthenticationArgs.builder()
            .systemAssignedManagedIdentity(
                systemAssignedManagedIdentity.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            ).build()
}

/**
 * Builder for [DataLakeFabricStorageAuthenticationArgs].
 */
@PulumiTagMarker
public class DataLakeFabricStorageAuthenticationArgsBuilder internal constructor() {
    private var systemAssignedManagedIdentity: Output<ManagedIdentityAuthenticationArgs>? = null

    /**
     * @param value Configuration for managed identity authentication.
     */
    @JvmName("fybbbmjncikywtgb")
    public suspend
    fun systemAssignedManagedIdentity(`value`: Output<ManagedIdentityAuthenticationArgs>) {
        this.systemAssignedManagedIdentity = value
    }

    /**
     * @param value Configuration for managed identity authentication.
     */
    @JvmName("epdwksoxphcymnsv")
    public suspend fun systemAssignedManagedIdentity(`value`: ManagedIdentityAuthenticationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.systemAssignedManagedIdentity = mapped
    }

    /**
     * @param argument Configuration for managed identity authentication.
     */
    @JvmName("rdttekujoivpadly")
    public suspend
    fun systemAssignedManagedIdentity(argument: suspend ManagedIdentityAuthenticationArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedIdentityAuthenticationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.systemAssignedManagedIdentity = mapped
    }

    internal fun build(): DataLakeFabricStorageAuthenticationArgs =
        DataLakeFabricStorageAuthenticationArgs(
            systemAssignedManagedIdentity = systemAssignedManagedIdentity ?: throw
                PulumiNullFieldException("systemAssignedManagedIdentity"),
        )
}
