@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.DataLakeLocalStorageArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * DataLake Local Storage details.
 * @property volumeName Volume name to write to.
 */
public data class DataLakeLocalStorageArgs(
    public val volumeName: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.DataLakeLocalStorageArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.inputs.DataLakeLocalStorageArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.DataLakeLocalStorageArgs.builder()
            .volumeName(volumeName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataLakeLocalStorageArgs].
 */
@PulumiTagMarker
public class DataLakeLocalStorageArgsBuilder internal constructor() {
    private var volumeName: Output<String>? = null

    /**
     * @param value Volume name to write to.
     */
    @JvmName("snkeyoejcnxikqxu")
    public suspend fun volumeName(`value`: Output<String>) {
        this.volumeName = value
    }

    /**
     * @param value Volume name to write to.
     */
    @JvmName("bvreobdvelnxhrdp")
    public suspend fun volumeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.volumeName = mapped
    }

    internal fun build(): DataLakeLocalStorageArgs = DataLakeLocalStorageArgs(
        volumeName = volumeName ?: throw PulumiNullFieldException("volumeName"),
    )
}
