@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.FabricNamesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Fabric one lake names.
 * @property lakehouseName Fabric one lake house name.
 * @property workspaceName Fabric one lake workspace name.
 */
public data class FabricNamesArgs(
    public val lakehouseName: Output<String>,
    public val workspaceName: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.FabricNamesArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.inputs.FabricNamesArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.FabricNamesArgs.builder()
            .lakehouseName(lakehouseName.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FabricNamesArgs].
 */
@PulumiTagMarker
public class FabricNamesArgsBuilder internal constructor() {
    private var lakehouseName: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value Fabric one lake house name.
     */
    @JvmName("ceindbllrusfgrnw")
    public suspend fun lakehouseName(`value`: Output<String>) {
        this.lakehouseName = value
    }

    /**
     * @param value Fabric one lake workspace name.
     */
    @JvmName("afybjhsmlbabljtv")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value Fabric one lake house name.
     */
    @JvmName("tjcyvaelvxktqmsy")
    public suspend fun lakehouseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lakehouseName = mapped
    }

    /**
     * @param value Fabric one lake workspace name.
     */
    @JvmName("kionqlmlsrhxjqiv")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): FabricNamesArgs = FabricNamesArgs(
        lakehouseName = lakehouseName ?: throw PulumiNullFieldException("lakehouseName"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
