@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.GetBrokerAuthenticationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property authenticationName Name of MQ broker/authentication resource
 * @property brokerName Name of MQ broker resource
 * @property mqName Name of MQ resource
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetBrokerAuthenticationPlainArgs(
    public val authenticationName: String,
    public val brokerName: String,
    public val mqName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.GetBrokerAuthenticationPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.iotoperationsmq.inputs.GetBrokerAuthenticationPlainArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.GetBrokerAuthenticationPlainArgs.builder()
            .authenticationName(authenticationName.let({ args0 -> args0 }))
            .brokerName(brokerName.let({ args0 -> args0 }))
            .mqName(mqName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBrokerAuthenticationPlainArgs].
 */
@PulumiTagMarker
public class GetBrokerAuthenticationPlainArgsBuilder internal constructor() {
    private var authenticationName: String? = null

    private var brokerName: String? = null

    private var mqName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of MQ broker/authentication resource
     */
    @JvmName("jureybtlevrcxnqj")
    public suspend fun authenticationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.authenticationName = mapped
    }

    /**
     * @param value Name of MQ broker resource
     */
    @JvmName("dmpmqlxcamfvpkyx")
    public suspend fun brokerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.brokerName = mapped
    }

    /**
     * @param value Name of MQ resource
     */
    @JvmName("kykekrvqcquimnmp")
    public suspend fun mqName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.mqName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hmedxlxcnxlauadd")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetBrokerAuthenticationPlainArgs = GetBrokerAuthenticationPlainArgs(
        authenticationName = authenticationName ?: throw PulumiNullFieldException("authenticationName"),
        brokerName = brokerName ?: throw PulumiNullFieldException("brokerName"),
        mqName = mqName ?: throw PulumiNullFieldException("mqName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
