@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.GetBrokerListenerPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property brokerName Name of MQ broker resource
 * @property listenerName Name of MQ broker/listener resource
 * @property mqName Name of MQ resource
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetBrokerListenerPlainArgs(
    public val brokerName: String,
    public val listenerName: String,
    public val mqName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.GetBrokerListenerPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.inputs.GetBrokerListenerPlainArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.GetBrokerListenerPlainArgs.builder()
            .brokerName(brokerName.let({ args0 -> args0 }))
            .listenerName(listenerName.let({ args0 -> args0 }))
            .mqName(mqName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBrokerListenerPlainArgs].
 */
@PulumiTagMarker
public class GetBrokerListenerPlainArgsBuilder internal constructor() {
    private var brokerName: String? = null

    private var listenerName: String? = null

    private var mqName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of MQ broker resource
     */
    @JvmName("shyvdirpmrliyfva")
    public suspend fun brokerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.brokerName = mapped
    }

    /**
     * @param value Name of MQ broker/listener resource
     */
    @JvmName("ofmufbhnoxybabrc")
    public suspend fun listenerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.listenerName = mapped
    }

    /**
     * @param value Name of MQ resource
     */
    @JvmName("xckuhtlydcahpwoc")
    public suspend fun mqName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.mqName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("iubbtgxwriuajidl")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetBrokerListenerPlainArgs = GetBrokerListenerPlainArgs(
        brokerName = brokerName ?: throw PulumiNullFieldException("brokerName"),
        listenerName = listenerName ?: throw PulumiNullFieldException("listenerName"),
        mqName = mqName ?: throw PulumiNullFieldException("mqName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
