@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.KafkaRemoteBrokerAuthenticationTypesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Kafka RemoteBrokerConnection Authentication types. NOTE - Enum only one method is allowed to be passed.
 * @property sasl Sasl remote broker authentication method.
 * @property systemAssignedManagedIdentity Managed identity remote broker authentication method.
 * @property x509 X509 remote broker authentication method.
 */
public data class KafkaRemoteBrokerAuthenticationTypesArgs(
    public val sasl: Output<SaslRemoteBrokerBasicAuthenticationArgs>? = null,
    public val systemAssignedManagedIdentity: Output<ManagedIdentityAuthenticationArgs>? = null,
    public val x509: Output<KafkaX509AuthenticationArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.KafkaRemoteBrokerAuthenticationTypesArgs> {
    override fun toJava():
        com.pulumi.azurenative.iotoperationsmq.inputs.KafkaRemoteBrokerAuthenticationTypesArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.KafkaRemoteBrokerAuthenticationTypesArgs.builder()
            .sasl(sasl?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .systemAssignedManagedIdentity(
                systemAssignedManagedIdentity?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .x509(x509?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [KafkaRemoteBrokerAuthenticationTypesArgs].
 */
@PulumiTagMarker
public class KafkaRemoteBrokerAuthenticationTypesArgsBuilder internal constructor() {
    private var sasl: Output<SaslRemoteBrokerBasicAuthenticationArgs>? = null

    private var systemAssignedManagedIdentity: Output<ManagedIdentityAuthenticationArgs>? = null

    private var x509: Output<KafkaX509AuthenticationArgs>? = null

    /**
     * @param value Sasl remote broker authentication method.
     */
    @JvmName("hycvyxoxropkmngn")
    public suspend fun sasl(`value`: Output<SaslRemoteBrokerBasicAuthenticationArgs>) {
        this.sasl = value
    }

    /**
     * @param value Managed identity remote broker authentication method.
     */
    @JvmName("yoymyaaaigfxpnwk")
    public suspend
    fun systemAssignedManagedIdentity(`value`: Output<ManagedIdentityAuthenticationArgs>) {
        this.systemAssignedManagedIdentity = value
    }

    /**
     * @param value X509 remote broker authentication method.
     */
    @JvmName("fexeotkrvayceofk")
    public suspend fun x509(`value`: Output<KafkaX509AuthenticationArgs>) {
        this.x509 = value
    }

    /**
     * @param value Sasl remote broker authentication method.
     */
    @JvmName("omhtlkqvvdpioyhc")
    public suspend fun sasl(`value`: SaslRemoteBrokerBasicAuthenticationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sasl = mapped
    }

    /**
     * @param argument Sasl remote broker authentication method.
     */
    @JvmName("botywbmstjdrxrma")
    public suspend
    fun sasl(argument: suspend SaslRemoteBrokerBasicAuthenticationArgsBuilder.() -> Unit) {
        val toBeMapped = SaslRemoteBrokerBasicAuthenticationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.sasl = mapped
    }

    /**
     * @param value Managed identity remote broker authentication method.
     */
    @JvmName("rsrkuyqcmilabfxx")
    public suspend fun systemAssignedManagedIdentity(`value`: ManagedIdentityAuthenticationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemAssignedManagedIdentity = mapped
    }

    /**
     * @param argument Managed identity remote broker authentication method.
     */
    @JvmName("lpiwxnbsvjihwbfh")
    public suspend
    fun systemAssignedManagedIdentity(argument: suspend ManagedIdentityAuthenticationArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedIdentityAuthenticationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.systemAssignedManagedIdentity = mapped
    }

    /**
     * @param value X509 remote broker authentication method.
     */
    @JvmName("pajwbtugcbctcnml")
    public suspend fun x509(`value`: KafkaX509AuthenticationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.x509 = mapped
    }

    /**
     * @param argument X509 remote broker authentication method.
     */
    @JvmName("qusgoxqahqxdgmap")
    public suspend fun x509(argument: suspend KafkaX509AuthenticationArgsBuilder.() -> Unit) {
        val toBeMapped = KafkaX509AuthenticationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.x509 = mapped
    }

    internal fun build(): KafkaRemoteBrokerAuthenticationTypesArgs =
        KafkaRemoteBrokerAuthenticationTypesArgs(
            sasl = sasl,
            systemAssignedManagedIdentity = systemAssignedManagedIdentity,
            x509 = x509,
        )
}
