@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.KafkaRoutesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Kafka Routes properties. NOTE - Enum only one method is allowed to be passed.
 * @property kafkaToMqtt Kafka to Mqtt route.
 * @property mqttToKafka Mqtt to Kafka route.
 */
public data class KafkaRoutesArgs(
    public val kafkaToMqtt: Output<KafkaToMqttRoutesArgs>? = null,
    public val mqttToKafka: Output<MqttToKafkaRoutesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.KafkaRoutesArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.inputs.KafkaRoutesArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.KafkaRoutesArgs.builder()
            .kafkaToMqtt(kafkaToMqtt?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .mqttToKafka(mqttToKafka?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [KafkaRoutesArgs].
 */
@PulumiTagMarker
public class KafkaRoutesArgsBuilder internal constructor() {
    private var kafkaToMqtt: Output<KafkaToMqttRoutesArgs>? = null

    private var mqttToKafka: Output<MqttToKafkaRoutesArgs>? = null

    /**
     * @param value Kafka to Mqtt route.
     */
    @JvmName("umxalxooimhqwraq")
    public suspend fun kafkaToMqtt(`value`: Output<KafkaToMqttRoutesArgs>) {
        this.kafkaToMqtt = value
    }

    /**
     * @param value Mqtt to Kafka route.
     */
    @JvmName("llnjymlcujvxoexq")
    public suspend fun mqttToKafka(`value`: Output<MqttToKafkaRoutesArgs>) {
        this.mqttToKafka = value
    }

    /**
     * @param value Kafka to Mqtt route.
     */
    @JvmName("flkpvhfqqvtnknig")
    public suspend fun kafkaToMqtt(`value`: KafkaToMqttRoutesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kafkaToMqtt = mapped
    }

    /**
     * @param argument Kafka to Mqtt route.
     */
    @JvmName("enqqdducqpcfpuue")
    public suspend fun kafkaToMqtt(argument: suspend KafkaToMqttRoutesArgsBuilder.() -> Unit) {
        val toBeMapped = KafkaToMqttRoutesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.kafkaToMqtt = mapped
    }

    /**
     * @param value Mqtt to Kafka route.
     */
    @JvmName("mipcnvbdlrultrwb")
    public suspend fun mqttToKafka(`value`: MqttToKafkaRoutesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mqttToKafka = mapped
    }

    /**
     * @param argument Mqtt to Kafka route.
     */
    @JvmName("rfjgmnovigrxhjbq")
    public suspend fun mqttToKafka(argument: suspend MqttToKafkaRoutesArgsBuilder.() -> Unit) {
        val toBeMapped = MqttToKafkaRoutesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.mqttToKafka = mapped
    }

    internal fun build(): KafkaRoutesArgs = KafkaRoutesArgs(
        kafkaToMqtt = kafkaToMqtt,
        mqttToKafka = mqttToKafka,
    )
}
