@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.KeyVaultCredentialsPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * KeyVault credentials properties. NOTE - Future this will be ENUM.
 * @property servicePrincipalLocalSecretName KeyVault service principal local secret name.
 */
public data class KeyVaultCredentialsPropertiesArgs(
    public val servicePrincipalLocalSecretName: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.KeyVaultCredentialsPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.iotoperationsmq.inputs.KeyVaultCredentialsPropertiesArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.KeyVaultCredentialsPropertiesArgs.builder()
            .servicePrincipalLocalSecretName(
                servicePrincipalLocalSecretName.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [KeyVaultCredentialsPropertiesArgs].
 */
@PulumiTagMarker
public class KeyVaultCredentialsPropertiesArgsBuilder internal constructor() {
    private var servicePrincipalLocalSecretName: Output<String>? = null

    /**
     * @param value KeyVault service principal local secret name.
     */
    @JvmName("dhsmaggfowprjquo")
    public suspend fun servicePrincipalLocalSecretName(`value`: Output<String>) {
        this.servicePrincipalLocalSecretName = value
    }

    /**
     * @param value KeyVault service principal local secret name.
     */
    @JvmName("ibwicuvehbwopllq")
    public suspend fun servicePrincipalLocalSecretName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.servicePrincipalLocalSecretName = mapped
    }

    internal fun build(): KeyVaultCredentialsPropertiesArgs = KeyVaultCredentialsPropertiesArgs(
        servicePrincipalLocalSecretName = servicePrincipalLocalSecretName ?: throw
            PulumiNullFieldException("servicePrincipalLocalSecretName"),
    )
}
