@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.KeyVaultSecretObjectArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * KeyVault secret object properties
 * @property name KeyVault secret name.
 * @property version KeyVault secret version.
 */
public data class KeyVaultSecretObjectArgs(
    public val name: Output<String>,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.KeyVaultSecretObjectArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.inputs.KeyVaultSecretObjectArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.KeyVaultSecretObjectArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KeyVaultSecretObjectArgs].
 */
@PulumiTagMarker
public class KeyVaultSecretObjectArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value KeyVault secret name.
     */
    @JvmName("litcganwkjenrlvp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value KeyVault secret version.
     */
    @JvmName("pvmkfetbugoxqdtk")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value KeyVault secret name.
     */
    @JvmName("mxdqmnjiwghrrgnc")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value KeyVault secret version.
     */
    @JvmName("xnhayfwmorohochq")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): KeyVaultSecretObjectArgs = KeyVaultSecretObjectArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        version = version,
    )
}
