@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.LocalBrokerAuthenticationMethodsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Mqtt Local Broker Authentication details. Only one method at a time is supported. Default - kubernetes authentication
 * @property kubernetes Kubernetes local broker authentication method.
 */
public data class LocalBrokerAuthenticationMethodsArgs(
    public val kubernetes: Output<LocalBrokerKubernetesAuthenticationArgs>,
) :
    ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.LocalBrokerAuthenticationMethodsArgs> {
    override fun toJava():
        com.pulumi.azurenative.iotoperationsmq.inputs.LocalBrokerAuthenticationMethodsArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.LocalBrokerAuthenticationMethodsArgs.builder()
            .kubernetes(kubernetes.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [LocalBrokerAuthenticationMethodsArgs].
 */
@PulumiTagMarker
public class LocalBrokerAuthenticationMethodsArgsBuilder internal constructor() {
    private var kubernetes: Output<LocalBrokerKubernetesAuthenticationArgs>? = null

    /**
     * @param value Kubernetes local broker authentication method.
     */
    @JvmName("dmuoujpdppnouxxj")
    public suspend fun kubernetes(`value`: Output<LocalBrokerKubernetesAuthenticationArgs>) {
        this.kubernetes = value
    }

    /**
     * @param value Kubernetes local broker authentication method.
     */
    @JvmName("xsrhynxvxkqmhtgf")
    public suspend fun kubernetes(`value`: LocalBrokerKubernetesAuthenticationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kubernetes = mapped
    }

    /**
     * @param argument Kubernetes local broker authentication method.
     */
    @JvmName("rjfitgnpdgrauxpd")
    public suspend
    fun kubernetes(argument: suspend LocalBrokerKubernetesAuthenticationArgsBuilder.() -> Unit) {
        val toBeMapped = LocalBrokerKubernetesAuthenticationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.kubernetes = mapped
    }

    internal fun build(): LocalBrokerAuthenticationMethodsArgs = LocalBrokerAuthenticationMethodsArgs(
        kubernetes = kubernetes ?: throw PulumiNullFieldException("kubernetes"),
    )
}
