@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.ManagedIdentityAuthenticationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Managed identity authentication details.
 * @property audience Token audience.
 * @property extensionName Arc Extension name.
 */
public data class ManagedIdentityAuthenticationArgs(
    public val audience: Output<String>,
    public val extensionName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.ManagedIdentityAuthenticationArgs> {
    override fun toJava():
        com.pulumi.azurenative.iotoperationsmq.inputs.ManagedIdentityAuthenticationArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.ManagedIdentityAuthenticationArgs.builder()
            .audience(audience.applyValue({ args0 -> args0 }))
            .extensionName(extensionName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedIdentityAuthenticationArgs].
 */
@PulumiTagMarker
public class ManagedIdentityAuthenticationArgsBuilder internal constructor() {
    private var audience: Output<String>? = null

    private var extensionName: Output<String>? = null

    /**
     * @param value Token audience.
     */
    @JvmName("yoyjemjfjxliyvnc")
    public suspend fun audience(`value`: Output<String>) {
        this.audience = value
    }

    /**
     * @param value Arc Extension name.
     */
    @JvmName("dhevaospoplbfkiw")
    public suspend fun extensionName(`value`: Output<String>) {
        this.extensionName = value
    }

    /**
     * @param value Token audience.
     */
    @JvmName("fdethtbnorgmvhqk")
    public suspend fun audience(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.audience = mapped
    }

    /**
     * @param value Arc Extension name.
     */
    @JvmName("cblfsaxwsjxoilxy")
    public suspend fun extensionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extensionName = mapped
    }

    internal fun build(): ManagedIdentityAuthenticationArgs = ManagedIdentityAuthenticationArgs(
        audience = audience ?: throw PulumiNullFieldException("audience"),
        extensionName = extensionName,
    )
}
