@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.ManualCertMethodArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manual TLS server certificate management through a defined secret
 * @property secretName secret containing TLS cert.
 * @property secretNamespace namespace of secret; omit to use default namespace.
 */
public data class ManualCertMethodArgs(
    public val secretName: Output<String>,
    public val secretNamespace: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.ManualCertMethodArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.inputs.ManualCertMethodArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.ManualCertMethodArgs.builder()
            .secretName(secretName.applyValue({ args0 -> args0 }))
            .secretNamespace(secretNamespace?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManualCertMethodArgs].
 */
@PulumiTagMarker
public class ManualCertMethodArgsBuilder internal constructor() {
    private var secretName: Output<String>? = null

    private var secretNamespace: Output<String>? = null

    /**
     * @param value secret containing TLS cert.
     */
    @JvmName("bpntunkdxcbqbrgp")
    public suspend fun secretName(`value`: Output<String>) {
        this.secretName = value
    }

    /**
     * @param value namespace of secret; omit to use default namespace.
     */
    @JvmName("xwdedjnrwmwlxscd")
    public suspend fun secretNamespace(`value`: Output<String>) {
        this.secretNamespace = value
    }

    /**
     * @param value secret containing TLS cert.
     */
    @JvmName("wxufjscwaqrfyydm")
    public suspend fun secretName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secretName = mapped
    }

    /**
     * @param value namespace of secret; omit to use default namespace.
     */
    @JvmName("vtvlynengomlovhh")
    public suspend fun secretNamespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretNamespace = mapped
    }

    internal fun build(): ManualCertMethodArgs = ManualCertMethodArgs(
        secretName = secretName ?: throw PulumiNullFieldException("secretName"),
        secretNamespace = secretNamespace,
    )
}
