@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.MqttBridgeRemoteBrokerAuthenticationMethodsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * MqttBridge RemoteBrokerConnection Authentication methods. NOTE - Enum only one is allowed to be passed.
 * @property systemAssignedManagedIdentity Managed identity remote broker authentication method.
 * @property x509 X509 remote broker authentication method.
 */
public data class MqttBridgeRemoteBrokerAuthenticationMethodsArgs(
    public val systemAssignedManagedIdentity: Output<ManagedIdentityAuthenticationArgs>? = null,
    public val x509: Output<MqttBridgeRemoteBrokerX509AuthenticationArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.MqttBridgeRemoteBrokerAuthenticationMethodsArgs> {
    override fun toJava():
        com.pulumi.azurenative.iotoperationsmq.inputs.MqttBridgeRemoteBrokerAuthenticationMethodsArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.MqttBridgeRemoteBrokerAuthenticationMethodsArgs.builder()
            .systemAssignedManagedIdentity(
                systemAssignedManagedIdentity?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .x509(x509?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [MqttBridgeRemoteBrokerAuthenticationMethodsArgs].
 */
@PulumiTagMarker
public class MqttBridgeRemoteBrokerAuthenticationMethodsArgsBuilder internal constructor() {
    private var systemAssignedManagedIdentity: Output<ManagedIdentityAuthenticationArgs>? = null

    private var x509: Output<MqttBridgeRemoteBrokerX509AuthenticationArgs>? = null

    /**
     * @param value Managed identity remote broker authentication method.
     */
    @JvmName("avomfvophemhpafg")
    public suspend
    fun systemAssignedManagedIdentity(`value`: Output<ManagedIdentityAuthenticationArgs>) {
        this.systemAssignedManagedIdentity = value
    }

    /**
     * @param value X509 remote broker authentication method.
     */
    @JvmName("sdwfdwiydignqupy")
    public suspend fun x509(`value`: Output<MqttBridgeRemoteBrokerX509AuthenticationArgs>) {
        this.x509 = value
    }

    /**
     * @param value Managed identity remote broker authentication method.
     */
    @JvmName("rktuekbtkdjapaux")
    public suspend fun systemAssignedManagedIdentity(`value`: ManagedIdentityAuthenticationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemAssignedManagedIdentity = mapped
    }

    /**
     * @param argument Managed identity remote broker authentication method.
     */
    @JvmName("rvtkjxklisrknsjn")
    public suspend
    fun systemAssignedManagedIdentity(argument: suspend ManagedIdentityAuthenticationArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedIdentityAuthenticationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.systemAssignedManagedIdentity = mapped
    }

    /**
     * @param value X509 remote broker authentication method.
     */
    @JvmName("gapmnkfunfyeihsw")
    public suspend fun x509(`value`: MqttBridgeRemoteBrokerX509AuthenticationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.x509 = mapped
    }

    /**
     * @param argument X509 remote broker authentication method.
     */
    @JvmName("xkqtuohqtbcoepkf")
    public suspend
    fun x509(argument: suspend MqttBridgeRemoteBrokerX509AuthenticationArgsBuilder.() -> Unit) {
        val toBeMapped = MqttBridgeRemoteBrokerX509AuthenticationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.x509 = mapped
    }

    internal fun build(): MqttBridgeRemoteBrokerAuthenticationMethodsArgs =
        MqttBridgeRemoteBrokerAuthenticationMethodsArgs(
            systemAssignedManagedIdentity = systemAssignedManagedIdentity,
            x509 = x509,
        )
}
