@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.MqttBridgeRoutesArgs.builder
import com.pulumi.azurenative.iotoperationsmq.kotlin.enums.MqttBridgeRouteDirection
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * MqttBridgeTopicMap route properties
 * @property direction Direction of the route.
 * @property name Name of the route.
 * @property qos Qos for MQTT connection.
 * @property sharedSubscription Shared subscription topic details.
 * @property source Source topic of the route.
 * @property target Target topic of the route. Ignore if same as source
 */
public data class MqttBridgeRoutesArgs(
    public val direction: Output<Either<String, MqttBridgeRouteDirection>>,
    public val name: Output<String>,
    public val qos: Output<Int>? = null,
    public val sharedSubscription: Output<MqttBridgeRouteSharedSubscriptionArgs>? = null,
    public val source: Output<String>,
    public val target: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.MqttBridgeRoutesArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.inputs.MqttBridgeRoutesArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.MqttBridgeRoutesArgs.builder()
            .direction(
                direction.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .name(name.applyValue({ args0 -> args0 }))
            .qos(qos?.applyValue({ args0 -> args0 }))
            .sharedSubscription(
                sharedSubscription?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .source(source.applyValue({ args0 -> args0 }))
            .target(target?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MqttBridgeRoutesArgs].
 */
@PulumiTagMarker
public class MqttBridgeRoutesArgsBuilder internal constructor() {
    private var direction: Output<Either<String, MqttBridgeRouteDirection>>? = null

    private var name: Output<String>? = null

    private var qos: Output<Int>? = null

    private var sharedSubscription: Output<MqttBridgeRouteSharedSubscriptionArgs>? = null

    private var source: Output<String>? = null

    private var target: Output<String>? = null

    /**
     * @param value Direction of the route.
     */
    @JvmName("cbuwrmmpillwteis")
    public suspend fun direction(`value`: Output<Either<String, MqttBridgeRouteDirection>>) {
        this.direction = value
    }

    /**
     * @param value Name of the route.
     */
    @JvmName("kbvlphefmnjbstey")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Qos for MQTT connection.
     */
    @JvmName("slusbkpqegkmdlvl")
    public suspend fun qos(`value`: Output<Int>) {
        this.qos = value
    }

    /**
     * @param value Shared subscription topic details.
     */
    @JvmName("jbsjxxuwqykqrxef")
    public suspend fun sharedSubscription(`value`: Output<MqttBridgeRouteSharedSubscriptionArgs>) {
        this.sharedSubscription = value
    }

    /**
     * @param value Source topic of the route.
     */
    @JvmName("orwqkwqmuaikvkib")
    public suspend fun source(`value`: Output<String>) {
        this.source = value
    }

    /**
     * @param value Target topic of the route. Ignore if same as source
     */
    @JvmName("qvpogobbmmyytrif")
    public suspend fun target(`value`: Output<String>) {
        this.target = value
    }

    /**
     * @param value Direction of the route.
     */
    @JvmName("dbfdojnglkfvkhxe")
    public suspend fun direction(`value`: Either<String, MqttBridgeRouteDirection>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.direction = mapped
    }

    /**
     * @param value Direction of the route.
     */
    @JvmName("yfxnqxnrmhsblwdp")
    public fun direction(`value`: String) {
        val toBeMapped = Either.ofLeft<String, MqttBridgeRouteDirection>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.direction = mapped
    }

    /**
     * @param value Direction of the route.
     */
    @JvmName("jbwvnurernfqnmxv")
    public fun direction(`value`: MqttBridgeRouteDirection) {
        val toBeMapped = Either.ofRight<String, MqttBridgeRouteDirection>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.direction = mapped
    }

    /**
     * @param value Name of the route.
     */
    @JvmName("ayfdcecrcdxhadfv")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Qos for MQTT connection.
     */
    @JvmName("etmvlsvnmyqasqrk")
    public suspend fun qos(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.qos = mapped
    }

    /**
     * @param value Shared subscription topic details.
     */
    @JvmName("kfdbwtttdpiyyvvk")
    public suspend fun sharedSubscription(`value`: MqttBridgeRouteSharedSubscriptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharedSubscription = mapped
    }

    /**
     * @param argument Shared subscription topic details.
     */
    @JvmName("yiyrakvklfsciwgv")
    public suspend
    fun sharedSubscription(argument: suspend MqttBridgeRouteSharedSubscriptionArgsBuilder.() -> Unit) {
        val toBeMapped = MqttBridgeRouteSharedSubscriptionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.sharedSubscription = mapped
    }

    /**
     * @param value Source topic of the route.
     */
    @JvmName("swifpuqxeybitelt")
    public suspend fun source(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param value Target topic of the route. Ignore if same as source
     */
    @JvmName("kiusbocssqlqerbs")
    public suspend fun target(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.target = mapped
    }

    internal fun build(): MqttBridgeRoutesArgs = MqttBridgeRoutesArgs(
        direction = direction ?: throw PulumiNullFieldException("direction"),
        name = name ?: throw PulumiNullFieldException("name"),
        qos = qos,
        sharedSubscription = sharedSubscription,
        source = source ?: throw PulumiNullFieldException("source"),
        target = target,
    )
}
