@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.SaslRemoteBrokerBasicAuthenticationTokenArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Kafka RemoteBrokerConnection Sasl Authentication token properties. NOTE - Enum only one method is allowed to be passed.
 * @property keyVault Keyvault token keyvault secret properties.
 * @property secretName Secret where cert details are stored.
 */
public data class SaslRemoteBrokerBasicAuthenticationTokenArgs(
    public val keyVault: Output<KafkaTokenKeyVaultPropertiesArgs>? = null,
    public val secretName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.SaslRemoteBrokerBasicAuthenticationTokenArgs> {
    override fun toJava():
        com.pulumi.azurenative.iotoperationsmq.inputs.SaslRemoteBrokerBasicAuthenticationTokenArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.SaslRemoteBrokerBasicAuthenticationTokenArgs.builder()
            .keyVault(keyVault?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .secretName(secretName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SaslRemoteBrokerBasicAuthenticationTokenArgs].
 */
@PulumiTagMarker
public class SaslRemoteBrokerBasicAuthenticationTokenArgsBuilder internal constructor() {
    private var keyVault: Output<KafkaTokenKeyVaultPropertiesArgs>? = null

    private var secretName: Output<String>? = null

    /**
     * @param value Keyvault token keyvault secret properties.
     */
    @JvmName("nebttsnveftwmbti")
    public suspend fun keyVault(`value`: Output<KafkaTokenKeyVaultPropertiesArgs>) {
        this.keyVault = value
    }

    /**
     * @param value Secret where cert details are stored.
     */
    @JvmName("hcavtwbkfjdsxplp")
    public suspend fun secretName(`value`: Output<String>) {
        this.secretName = value
    }

    /**
     * @param value Keyvault token keyvault secret properties.
     */
    @JvmName("xslglsvgsimwdplf")
    public suspend fun keyVault(`value`: KafkaTokenKeyVaultPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVault = mapped
    }

    /**
     * @param argument Keyvault token keyvault secret properties.
     */
    @JvmName("bhpbjljurxwklmix")
    public suspend
    fun keyVault(argument: suspend KafkaTokenKeyVaultPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = KafkaTokenKeyVaultPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.keyVault = mapped
    }

    /**
     * @param value Secret where cert details are stored.
     */
    @JvmName("ykpbqhjxykxtvftt")
    public suspend fun secretName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretName = mapped
    }

    internal fun build(): SaslRemoteBrokerBasicAuthenticationTokenArgs =
        SaslRemoteBrokerBasicAuthenticationTokenArgs(
            keyVault = keyVault,
            secretName = secretName,
        )
}
