@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Automatic TLS server certificate management with cert-manager
 * @property duration Lifetime of automatically-managed certificate.
 * @property issuerRef cert-manager issuerRef.
 * @property privateKey Cert Manager private key.
 * @property renewBefore When to begin renewing automatically-managed certificate.
 * @property san Additional SANs to include in the certificate.
 * @property secretName Secret for storing server certificate. Any existing data will be overwritten.
 * @property secretNamespace Certificate K8S namespace. Omit to use default namespace.
 */
public data class AutomaticCertMethodResponse(
    public val duration: String? = null,
    public val issuerRef: CertManagerIssuerRefResponse,
    public val privateKey: CertManagerPrivateKeyResponse? = null,
    public val renewBefore: String? = null,
    public val san: SanForCertResponse? = null,
    public val secretName: String? = null,
    public val secretNamespace: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.AutomaticCertMethodResponse):
            AutomaticCertMethodResponse = AutomaticCertMethodResponse(
            duration = javaType.duration().map({ args0 -> args0 }).orElse(null),
            issuerRef = javaType.issuerRef().let({ args0 ->
                com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.CertManagerIssuerRefResponse.Companion.toKotlin(args0)
            }),
            privateKey = javaType.privateKey().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.CertManagerPrivateKeyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            renewBefore = javaType.renewBefore().map({ args0 -> args0 }).orElse(null),
            san = javaType.san().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.SanForCertResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            secretName = javaType.secretName().map({ args0 -> args0 }).orElse(null),
            secretNamespace = javaType.secretNamespace().map({ args0 -> args0 }).orElse(null),
        )
    }
}
