@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * SVID for BrokerAuthentication
 * @property agentSocketPath Mounted socket path for spiffe agent.
 * @property identityMaxRetry Maximum number of re-tries to fetch identity.
 * @property identityWaitRetryMs Maximum time to wait before fetching identity again.
 */
public data class BrokerAuthenticatorMethodSvidResponse(
    public val agentSocketPath: String,
    public val identityMaxRetry: Double? = null,
    public val identityWaitRetryMs: Double? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.BrokerAuthenticatorMethodSvidResponse):
            BrokerAuthenticatorMethodSvidResponse = BrokerAuthenticatorMethodSvidResponse(
            agentSocketPath = javaType.agentSocketPath(),
            identityMaxRetry = javaType.identityMaxRetry().map({ args0 -> args0 }).orElse(null),
            identityWaitRetryMs = javaType.identityWaitRetryMs().map({ args0 -> args0 }).orElse(null),
        )
    }
}
