@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * X509 for BrokerAuthentication.
 * @property attributes K8S Secret name to mount for username and password.
 * @property trustedClientCaCertConfigMap Trusted client ca cert config map.
 */
public data class BrokerAuthenticatorMethodX509Response(
    public val attributes: BrokerAuthenticatorMethodX509AttributesResponse? = null,
    public val trustedClientCaCertConfigMap: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.BrokerAuthenticatorMethodX509Response):
            BrokerAuthenticatorMethodX509Response = BrokerAuthenticatorMethodX509Response(
            attributes = javaType.attributes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.BrokerAuthenticatorMethodX509AttributesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            trustedClientCaCertConfigMap = javaType.trustedClientCaCertConfigMap().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
