@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Diagnostics setting specific to Broker
 * @property diagnosticServiceEndpoint Diagnostic Service endpoint
 * @property enableMetrics Knob to enable/disable metrics. Default = true
 * @property enableSelfCheck Enable self check on Broker via Probe.
 * @property enableSelfTracing Enable self tracing on the Broker so that every selfCheckFrequencySeconds a random message is traced even if it didn't have trace context.
 * @property enableTracing Knob to enable/disable entire tracing infrastructure.
 * @property logFormat Format for the logs generated.
 * @property logLevel Log level for the Broker.
 * @property maxCellMapLifetime Maximum time for the CellMap to live.
 * @property metricUpdateFrequencySeconds Metric update frequency in seconds.
 * @property probeImage Probe Image to run.
 * @property selfCheckFrequencySeconds Frequency for the self check to run.
 * @property selfCheckTimeoutSeconds Time out period of the self check.
 * @property selfTraceFrequencySeconds The frequency at which selfTrace should run.
 * @property spanChannelCapacity The number of the spans generated by the Tracing.
 */
public data class BrokerDiagnosticsResponse(
    public val diagnosticServiceEndpoint: String? = null,
    public val enableMetrics: Boolean? = null,
    public val enableSelfCheck: Boolean? = null,
    public val enableSelfTracing: Boolean? = null,
    public val enableTracing: Boolean? = null,
    public val logFormat: String? = null,
    public val logLevel: String? = null,
    public val maxCellMapLifetime: Double? = null,
    public val metricUpdateFrequencySeconds: Double? = null,
    public val probeImage: String? = null,
    public val selfCheckFrequencySeconds: Double? = null,
    public val selfCheckTimeoutSeconds: Double? = null,
    public val selfTraceFrequencySeconds: Double? = null,
    public val spanChannelCapacity: Double? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.BrokerDiagnosticsResponse):
            BrokerDiagnosticsResponse = BrokerDiagnosticsResponse(
            diagnosticServiceEndpoint = javaType.diagnosticServiceEndpoint().map({ args0 ->
                args0
            }).orElse(null),
            enableMetrics = javaType.enableMetrics().map({ args0 -> args0 }).orElse(null),
            enableSelfCheck = javaType.enableSelfCheck().map({ args0 -> args0 }).orElse(null),
            enableSelfTracing = javaType.enableSelfTracing().map({ args0 -> args0 }).orElse(null),
            enableTracing = javaType.enableTracing().map({ args0 -> args0 }).orElse(null),
            logFormat = javaType.logFormat().map({ args0 -> args0 }).orElse(null),
            logLevel = javaType.logLevel().map({ args0 -> args0 }).orElse(null),
            maxCellMapLifetime = javaType.maxCellMapLifetime().map({ args0 -> args0 }).orElse(null),
            metricUpdateFrequencySeconds = javaType.metricUpdateFrequencySeconds().map({ args0 ->
                args0
            }).orElse(null),
            probeImage = javaType.probeImage().map({ args0 -> args0 }).orElse(null),
            selfCheckFrequencySeconds = javaType.selfCheckFrequencySeconds().map({ args0 ->
                args0
            }).orElse(null),
            selfCheckTimeoutSeconds = javaType.selfCheckTimeoutSeconds().map({ args0 -> args0 }).orElse(null),
            selfTraceFrequencySeconds = javaType.selfTraceFrequencySeconds().map({ args0 ->
                args0
            }).orElse(null),
            spanChannelCapacity = javaType.spanChannelCapacity().map({ args0 -> args0 }).orElse(null),
        )
    }
}
