@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.Suppress

/**
 * Target storage for the DataLake. NOTE - Enum only storage is supported at a time.
 * @property datalakeStorage DataLake service storage details.
 * @property fabricOneLake Fabric one lake storage details.
 * @property localStorage Local storage details.
 */
public data class DataLakeTargetStorageResponse(
    public val datalakeStorage: DataLakeServiceStorageResponse? = null,
    public val fabricOneLake: DataLakeFabricStorageResponse? = null,
    public val localStorage: DataLakeLocalStorageResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.DataLakeTargetStorageResponse):
            DataLakeTargetStorageResponse = DataLakeTargetStorageResponse(
            datalakeStorage = javaType.datalakeStorage().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.DataLakeServiceStorageResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            fabricOneLake = javaType.fabricOneLake().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.DataLakeFabricStorageResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            localStorage = javaType.localStorage().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.DataLakeLocalStorageResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
