@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * DiskBackedMessageBufferSettings properties
 * @property ephemeralVolumeClaimSpec Use the specified persistent volume claim template to mount a "generic ephemeral volume" for the message buffer. See <https://kubernetes.io/docs/concepts/storage/ephemeral-volumes/#generic-ephemeral-volumes> for details.
 * @property maxSize The max size of the message buffer on disk. If a PVC template is specified using one of ephemeralVolumeClaimSpec or persistentVolumeClaimSpec, then this size is used as the request and limit sizes of that template. If neither ephemeralVolumeClaimSpec nor persistentVolumeClaimSpec are specified, then an emptyDir volume is mounted with this size as its limit. See <https://kubernetes.io/docs/concepts/storage/volumes/#emptydir> for details.
 * @property persistentVolumeClaimSpec Use the specified persistent volume claim template to mount a persistent volume for the message buffer.
 */
public data class DiskBackedMessageBufferSettingsResponse(
    public val ephemeralVolumeClaimSpec: VolumeClaimSpecResponse? = null,
    public val maxSize: String,
    public val persistentVolumeClaimSpec: VolumeClaimSpecResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.DiskBackedMessageBufferSettingsResponse):
            DiskBackedMessageBufferSettingsResponse = DiskBackedMessageBufferSettingsResponse(
            ephemeralVolumeClaimSpec = javaType.ephemeralVolumeClaimSpec().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.VolumeClaimSpecResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            maxSize = javaType.maxSize(),
            persistentVolumeClaimSpec = javaType.persistentVolumeClaimSpec().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.VolumeClaimSpecResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
