@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Fabric one lake guids.
 * @property lakehouseGuid Fabric one lake house guid.
 * @property workspaceGuid Fabric one lake workspace guid.
 */
public data class FabricGuidsResponse(
    public val lakehouseGuid: String,
    public val workspaceGuid: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.FabricGuidsResponse):
            FabricGuidsResponse = FabricGuidsResponse(
            lakehouseGuid = javaType.lakehouseGuid(),
            workspaceGuid = javaType.workspaceGuid(),
        )
    }
}
