@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 * Desired properties of the Frontend Instances of the DMQTT Broker
 * @property replicas Replicas is desired number of frontend replicas of the given distributed MQTT broker.
 * @property temporaryResourceLimits Defines the limits for resources of the frontend instances of the MQTT broker.
 * @property workers Number of logical frontend workers per pod.
 */
public data class FrontendResponse(
    public val replicas: Int,
    public val temporaryResourceLimits: TemporaryResourceLimitsConfigResponse? = null,
    public val workers: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.FrontendResponse):
            FrontendResponse = FrontendResponse(
            replicas = javaType.replicas(),
            temporaryResourceLimits = javaType.temporaryResourceLimits().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.TemporaryResourceLimitsConfigResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            workers = javaType.workers().map({ args0 -> args0 }).orElse(null),
        )
    }
}
