@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.Suppress

/**
 * Kafka TopicMap Batching properties
 * @property enabled The setting to enable or disable batching.
 * @property latencyMs The latency of message batching.
 * @property maxBytes The maximum bytes to send in a batch.
 * @property maxMessages The maximum messages to send in a batch.
 */
public data class KafkaTopicMapBatchingResponse(
    public val enabled: Boolean? = null,
    public val latencyMs: Int? = null,
    public val maxBytes: Double? = null,
    public val maxMessages: Double? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.KafkaTopicMapBatchingResponse):
            KafkaTopicMapBatchingResponse = KafkaTopicMapBatchingResponse(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            latencyMs = javaType.latencyMs().map({ args0 -> args0 }).orElse(null),
            maxBytes = javaType.maxBytes().map({ args0 -> args0 }).orElse(null),
            maxMessages = javaType.maxMessages().map({ args0 -> args0 }).orElse(null),
        )
    }
}
