@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Mqtt Local Broker Connection TLS details
 * @property tlsEnabled Tls Enabled on Local Broker Connection.
 * @property trustedCaCertificateConfigMap Trusted CA certificate config map name for Local Broker.
 */
public data class LocalBrokerConnectionTlsResponse(
    public val tlsEnabled: Boolean? = null,
    public val trustedCaCertificateConfigMap: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.LocalBrokerConnectionTlsResponse):
            LocalBrokerConnectionTlsResponse = LocalBrokerConnectionTlsResponse(
            tlsEnabled = javaType.tlsEnabled().map({ args0 -> args0 }).orElse(null),
            trustedCaCertificateConfigMap = javaType.trustedCaCertificateConfigMap().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
