@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * MqttBridgeTopicMap route properties
 * @property direction Direction of the route.
 * @property name Name of the route.
 * @property qos Qos for MQTT connection.
 * @property sharedSubscription Shared subscription topic details.
 * @property source Source topic of the route.
 * @property target Target topic of the route. Ignore if same as source
 */
public data class MqttBridgeRoutesResponse(
    public val direction: String,
    public val name: String,
    public val qos: Int? = null,
    public val sharedSubscription: MqttBridgeRouteSharedSubscriptionResponse? = null,
    public val source: String,
    public val target: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.MqttBridgeRoutesResponse):
            MqttBridgeRoutesResponse = MqttBridgeRoutesResponse(
            direction = javaType.direction(),
            name = javaType.name(),
            qos = javaType.qos().map({ args0 -> args0 }).orElse(null),
            sharedSubscription = javaType.sharedSubscription().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.MqttBridgeRouteSharedSubscriptionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            source = javaType.source(),
            target = javaType.target().map({ args0 -> args0 }).orElse(null),
        )
    }
}
