@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Mqtt to Kafka route properties
 * @property kafkaAcks The kafka acks to use.
 * @property kafkaTopic The kafka topic to publish to.
 * @property mqttTopic The mqtt topic to pull from.
 * @property name The name of the route.
 * @property qos The qos to use for mqtt.
 * @property sharedSubscription The properties for shared subscription.
 */
public data class MqttToKafkaRoutesResponse(
    public val kafkaAcks: String,
    public val kafkaTopic: String,
    public val mqttTopic: String,
    public val name: String,
    public val qos: Int? = null,
    public val sharedSubscription: KafkaSharedSubscriptionPropertiesResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.MqttToKafkaRoutesResponse):
            MqttToKafkaRoutesResponse = MqttToKafkaRoutesResponse(
            kafkaAcks = javaType.kafkaAcks(),
            kafkaTopic = javaType.kafkaTopic(),
            mqttTopic = javaType.mqttTopic(),
            name = javaType.name(),
            qos = javaType.qos().map({ args0 -> args0 }).orElse(null),
            sharedSubscription = javaType.sharedSubscription().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.KafkaSharedSubscriptionPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
