@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * ResourceInfoDefinition properties of Basic Rule. This defines the objects that represent the actions or topics, such as - method.Connect, method.Publish, etc.
 * @property method The type of action that the clients can perform on the broker: Connect, Publish or Subscribe.
 * @property topics A list of topics or topic patterns that match the topics that the clients can publish or subscribe to. This subfield is required if the method is Publish or Subscribe.
 */
public data class ResourceInfoDefinitionResponse(
    public val method: String,
    public val topics: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.ResourceInfoDefinitionResponse):
            ResourceInfoDefinitionResponse = ResourceInfoDefinitionResponse(
            method = javaType.method(),
            topics = javaType.topics().map({ args0 -> args0 }),
        )
    }
}
